<?php if(!defined('ABSPATH')) exit; ?>
<?php 
global $widgetPlace; 
if($widgetPlace != "home") return;

$widgetClass = ["rwcusWidget", "aboutWidget"];
$widgetClass[] = $bgcolor;
$widgetClass[] = $widgetPlace . "Widget";
if(!$aboutimage) $widgetClass[] = "noimage";
$widgetClass = implode(" ", $widgetClass);
?>
<div id="<?php echo $this->id ?>" class="<?php echo $widgetClass ?>">
	<div class="innerContainer">
		<div class="widgetContent">
			<?php if($titleAlign == "center") include('parts/_heading.php') ?>
			<div class="innerContent">
				<?php
				$imageData = wp_get_attachment_image_src($aboutimage, 'full');
				if(is_array($imageData)) {
					$image = $imageData[0];
				} else {
					$image = "";
				}
				if($image) : ?>
					<div class="imageBlock">
						<div class="image">
							<img <?php rwcusLazyThumb($image) ?> width="470" height="700" alt="<?php bloginfo("name") ?>"/>
						</div>
					</div>
				<?php endif; ?>
				<div class="infoBlock">
					<?php if($titleAlign == "left") include('parts/_heading.php') ?>
					<?php if($description) : ?>
						<div class="description">
							<?php echo $description ?>
						</div>
					<?php endif; ?>
					<div class="menuBlock">
						<?php
						for ($i=1; $i <= ABOUTWIDGET_MENU_COUNT; $i++) {
							if(${'aboutwidgetmenutext' . $i}) :
								?>
								<div class="item-container">
									<div class="item">
										<?php if(${'aboutwidgetmenulink' . $i}) : ?>
											<a class="container" href="<?php echo ${'aboutwidgetmenulink' . $i} ?>">
										<?php else: ?>
											<div class="container">
										<?php endif; ?>
										<div class="inner">
											<?php if(${'aboutwidgetmenuicon' . $i}) echo rwcusIcon(${'aboutwidgetmenuicon' . $i}); ?>
											<div class="title"><?php echo ${'aboutwidgetmenutext' . $i} ?></div>
										</div>
										<?php if(${'aboutwidgetmenulink' . $i}) : ?>
											</a>
										<?php else: ?>
											</div>
										<?php endif; ?>
									</div>
								</div>
								<?php
							endif;
						}
						?>
					</div>
					<?php if($buttonText || $buttonIcon) : ?>
						<a href="<?php echo $buttonLink ?>" rel="external" class="rwcusButton<?php if($lightbox) echo " lightbox"; ?>">
							<?php rwcusIcon($buttonIcon) ?>
							<?php echo $buttonText ?>
						</a>
					<?php endif; ?>
				</div>
			</div>
		</div>
	</div>
</div>
