<?php if(!defined('ABSPATH')) exit; ?>
<?php get_header(); ?>
<?php the_post(); ?>

<?php
$singleBlock = xoption('singleBlock');
// Single Type
$singleType = "single";
$relatedTitle = xoption("relatedHeader");
foreach(get_the_category() as $category) {
	if($category->term_id == xoption('productCategory') || rwcus_top_category($category->term_id) == xoption('productCategory')) {
		$singleType = 'product';
		$relatedTitle = xoption("relatedHeaderProduct");
	}
}
?>
<div id="main" class="innerContainer">
	<div id="content">
		<div id="single" class="<?php echo $singleType ?>">

			<div class="rwcusBox">

				<?php if(xoption("metaboxPosition") == "top") get_template_part('lib/rwcustema/metabox'); ?>

				<?php
				$noThumbCats = xoption('noThumbCats');
				if(is_array($noThumbCats)) :
					foreach(get_the_category() as $category) {
						if(in_array($category->cat_ID, $noThumbCats)) {
							$singleBlock = "none";
						}
					}
				endif;

				switch ($singleBlock) {
					case 'type1':
						?>
							<div id="singleBlock" class="type1">
								<div class="thumb">
									<?php if($text = get_post_meta(get_the_ID(), "metin", true)) : ?>
										<div class="text"><?php echo $text; ?></div>
									<?php endif; ?>
									<?php rwcusPrice() ?>
									<?php rwcusthumb() ?>
								</div>
							</div>
						<?php
						break;

					case 'type2':
						?>
							<div id="singleBlock" class="type2">
								<div class="thumb">
									<?php if($text = get_post_meta(get_the_ID(), "metin", true)) : ?>
										<div class="text"><?php echo $text; ?></div>
									<?php endif; ?>
									<?php rwcusPrice() ?>
									<?php rwcusthumb(); ?>
								</div>
							</div>
						<?php
						break;

					default:
					?>
						<div id="singleBlock" class="type3">
							<?php if($text = get_post_meta(get_the_ID(), "metin", true)) : ?>
								<div class="text"><?php echo $text; ?></div>
							<?php endif; ?>
							<?php rwcusPrice(); ?>
						</div>
						<?php
						break;
				}
				?>

				<div class="reading">
					<?php the_content(); ?>
					<?php if($singleType == 'product' && xoption("orderFormShortcode")) : ?>
						<div class="singleHeading">
							<div class="inner">
								<?php if($x = xoption("orderFormIcon")) : ?>
									<?php rwcusIcon($x) ?>
								<?php endif; ?>
								<div class="text"><?php echo xoption("orderFormTitle")?></div>
							</div>
						</div>
						<?php echo do_shortcode(xoption("orderFormShortcode"));?>
					<?php endif; ?>
				</div>

				<?php if(xoption("metaboxPosition") == "bottom") get_template_part('lib/rwcustema/metabox'); ?>

				<?php if( $x = wp_link_pages(array('link_before'=>'', 'link_after'=>'', 'before'=>'', 'echo' => false))): ?>
					<div id="page-links" class="rwcusnavi">
						<?php echo $x ?>
					</div>
				<?php endif;  ?>

				<?php if(xoption('showTags') && has_tag()) : ?>
					<div class="tags">
						<?php the_tags('','',''); ?>
					</div>
				<?php endif; ?>

			</div>

			<?php
			// BENZER YAZILAR:
			if(xoption('relatedCount') != 0) :
				$catIDs = "";
				$style2Cats = xoption("blogCategories");
				$listing = xoption('listButtonDefault');
				foreach(get_the_category() as $category) {
					if( $catIDs != "" ) { $catIDs .= ","; }
					$catIDs .= $category->cat_ID;
					if(is_array($style2Cats)) {
						if(in_array($category->cat_ID, $style2Cats)) {
							$listing = "style2";
						}
					}
				}
				$listStyle = substr($listing, -1);

				$relatedQuery = new wp_query(array('cat'=>$catIDs, 'posts_per_page'=>xoption('relatedCount'), 'orderby' => 'rand', 'post__not_in' => array($post->ID)));
				if($relatedQuery->have_posts()) : ?>
					<div id="related" class="rwcusBox shiftTop">
						<div class="singleHeading">
							<div class="inner">
								<?php rwcusIcon("liste") ?>
								<div class="text"><?php echo $relatedTitle; ?></div>
							</div>
						</div>
						<div class="rwcusWidget postsWidget advancedPostsWidget<?php echo $listStyle ?> rwcusCol col<?php echo xoption("archiveColumn"); ?> whiteBg">
							<div class="items">
								<div class="list">
									<?php
									while ($relatedQuery->have_posts()) : $relatedQuery->the_post();
										get_template_part('posts/post-style' . $listStyle);
									endwhile;
									?>
								</div>
							</div>
						</div>
					</div>
					<?php
				endif;
			endif;
			wp_reset_postdata();
			?>

			<?php if(xoption("singleCommentsActive") && comments_open()) comments_template(); ?>

		</div><!--single-->
	</div>
	<?php rwcus_sidebar($singleType); ?>
</div>
<?php get_footer(); ?>
