<?php
if(!defined('ABSPATH')) exit;

/*
Rwcuspanel v3.0
*/

class RwcusPanel {
	function __construct() {
		$this->dbField = "rwcus_".RWCUS_THEME_SLUG."_options";
		$this->handleSubmits();
	}

	function showPanel() {
		add_action('admin_menu', [$this, "adminSidebarMenus"]);
		add_action("admin_enqueue_scripts", [$this, "addScripts"]);
	}

	function handleSubmits() {
		if(is_admin() && current_user_can("administrator")) {
			if(isset($_GET['page']) && $_GET['page'] == 'rwcuspanel') {
				if(isset($_REQUEST['saveButton'])) {
					$this->saveOptions();
					return;
				}
				if(isset($_REQUEST['resetButton'])) {
					$this->resetOptions();
					return;
				}
				if(isset($_REQUEST['resetSectionButton'])) {
					$this->resetOptions($_REQUEST['activeSection']);
					return;
				}
				if(isset($_REQUEST['importButton'])) {
					$this->importOptions();
					return;
				}
				if(isset($_REQUEST['hiddenSaveButton'])) $this->saveOptions();
			} 
		}
	}

	function addScripts($hook_suffix) {
		if($hook_suffix == "toplevel_page_rwcuspanel") {
			wp_enqueue_script('media-upload');
			wp_enqueue_script('rwcuspanel', get_template_directory_uri() . '/rwcuspanel/scripts/scripts.js', ['jquery'], filemtime(get_template_directory() . '/rwcuspanel/scripts/scripts.js'), true );
			$editor_settings['codeEditor'] = wp_enqueue_code_editor(array('type' => 'text/html'));
			wp_localize_script('jquery', 'editor_settings', $editor_settings);	
			wp_enqueue_style('rwcuspanel', get_template_directory_uri() . '/rwcuspanel/css/style.css', [], filemtime(get_template_directory() . "/rwcuspanel/css/style.css"));
		}
	}

	function adminSidebarMenus() {
		add_menu_page('RW Panel', 'RW Panel', 'administrator', 'rwcuspanel', [$this, 'rwcuspanelPage']);
		add_submenu_page('rwcuspanel', 'Tema Ayarları', 'Tema Ayarları', 'administrator', 'rwcuspanel', [$this, 'rwcuspanelPage']);
		global $rwcusAdminSidebarMenus;
		foreach($rwcusAdminSidebarMenus as $slug => $data) {
			add_submenu_page('rwcuspanel', $data["name"], $data["name"], 'administrator', $slug, $data["func"]);
		}
	}

	function getOptions() {
		return json_decode(get_option($this->dbField));
	}

	function rwcuspanelPage() {
		if( get_option("rwcuspanel_need_update") ) {
			rwcusMakeRequest("activation");
			update_option("rwcuspanel_need_update", 0);
		}

		include( get_template_directory() . "/lib/rwcustema/rwcusoptions.php" );
		?>
		<div class="wrap" id="rwcuspanel" data-sections="<?php echo implode(',', array_keys($rwcusOptions)) ?>,importexport">
			<?php
			if(isset($this->outputMessage)) {
				?>
				<div class="updated">
					<p><?php echo $this->outputMessage ?></p>
				</div>
				<?php
				if(function_exists("rwcus_delete_cache")) rwcus_delete_cache();
			}
			?>
	
			<div id="top">
				<div class="logo">
					<img src="<?php echo esc_url(get_template_directory_uri()) ?>/rwcuspanel/images/logo.png" width="180" height="70" />
				</div>
				<div id="heading">
					<div class="arrow"></div>
					<div class="titles">
						<?php
						foreach ($rwcusOptions as $key => $value) {
							?>
							<div class="title" id="rwcuspanel_title_<?php echo $key ?>"><?php echo $value['title']; ?></div>
							<?php
						}
						?>
						<div class="title" id="rwcuspanel_title_importexport">
							İçe / Dışa Aktar	
						</div>
					</div>
					<a class="help" target="_blank" title="Renatif Web Çözümleri" href="https://www.renatif.com.tr">Renatif Web Çözümleri</a>
				</div>
			</div>
			<div id="rwcuspanelmain">
				<div id="rwcuspanelleft">
					<ul class="rwcusmenu">
						<?php
						foreach ($rwcusOptions as $key => $value) {
							?>
							<li id="rwcuspanel_menuitem_<?php echo $key ?>">
								<a href="#<?php echo $key ?>" data-hash="<?php echo $key; ?>" class="<?php echo $key; ?>">
									<span class="icon"></span>
									<?php echo $value['title']; ?>
								</a>
							</li>
							<?php
						}
						?>
						<li id="rwcuspanel_menuitem_importexport">
							<a href="#importexport" data-hash="importexport" class="importexport">
								<span class="icon"></span>
								İçe / Dışa Aktar
							</a>
						</li>
					</ul>
				</div>
	
				<div id="rwcuspanelright">
					<div id="sections">
						<form method="post" action="">
							<div style="display: none">
								<input type="submit">
							</div>
							<?php
							foreach ($rwcusOptions as $key => $value) {
								?>
								<div class="section" id="rwcuspanel_section_<?php echo $key ?>">
									<?php
									$datas = $value["data"];
									if( is_array($datas) ) {
										foreach ($datas as $key => $value) {
											include(get_template_directory() . "/rwcuspanel/parts/" . $value["type"] . ".php");
										}
									}
									?>
								</div>
								<?php
							}
							?>
							<div class="section" id="rwcuspanel_section_importexport">
								<div class="rwcuspanelItem aligntop codeeditor">
									<div class="desc">
										<div class="title">İçe Aktar</div>
									</div>
									<div class="infoBox">Daha önce dışa aktardığınız Rwcuspanel ayarlarına ait metin belgesini yükleyin veya dosya içindeki kodları kopyalayıp buraya yapıştırın. Ardından İçe Aktar butonu ile ayarları yükleyebilirsiniz.</div>
									<div class="formitem">
										<textarea name="rwcus_import" id="rwcus_import"></textarea>
									</div>
									<input id="hiddenUploadImportFileButton" type="file" style="display: none" />
									<input type="button" id="uploadImportFileButton" class="button button-primary" value="Dosya Yükle" style="margin-right: 5px" />
									<input type="submit" id="importButton" name="importButton" class="button" value="İçe Aktar" />
								</div>

								<div class="seperator"></div>

								<div class="rwcuspanelItem aligntop codeeditor">
									<div class="desc">
										<div class="title">Dışa Aktar</div>
									</div>
									<div class="infoBox">Rwcuspanel ayarlarını Dışa Aktar butonu ile bir metin belgesi olarak dışa aktarabilirsiniz. Daha sonra bu dosya içindeki kodları İçe Aktar bölümü ile tekrar yükleyebilirsiniz. Dışa aktarma son kaydedilen ayarları dışa aktarır.</div>
									<div class="formitem">
										<textarea disabled id="rwcus_export" name="rwcus_export"><?php 
										$options = $this->getOptions();
										echo json_encode($options, JSON_UNESCAPED_SLASHES); 
										?></textarea>
									</div>
									<input type="button" name="exportButton" class="button" value="Dışa Aktar" data-filename="rwcus_<?php echo RWCUS_THEME_SLUG ?>_options" />
								</div>
							</div>
							<p class="submit">
								<input name="hiddenSaveButton" type="hidden" value="1" />
								<input name="saveButton" class="button button-primary" type="submit" value="Değişiklikleri Kaydet" />
								<input name="resetButton" type="submit" class="button" value="Tüm Ayarları Sıfırla" onclick="return confirm('Tüm ayarlar varsayılanla sıfırlanacak, devam edilsin mi?')" />
								<input name="resetSectionButton" class="button" type="submit" value="Bölüm Ayarlarını Sıfırla" onclick="return confirm('Bölüm ayarları varsayılanla sıfırlanacak, devam edilsin mi?')"  />
								<input type="hidden" name="activeSection" value="general">
							</p>
						</form>
					</div>
				</div>
			</div>
	
		</div>
	<?php
	}	

	function saveOptions() {
		$postedOptions = [];
		foreach ($_POST as $key => $value) {
			if( substr($key, 0, strlen(RWCUS_THEME_SLUG)) . "_" === RWCUS_THEME_SLUG . "_") {
				if(is_string($value)) $value = stripslashes($value);
				$postedOptions[substr($key, strlen(RWCUS_THEME_SLUG) + 1)] = $value;
			}
		}
		if(count($postedOptions) > 0) {
			update_option($this->dbField, json_encode($postedOptions, JSON_UNESCAPED_SLASHES));
		}
		$this->outputMessage = "Ayarlar başarılı bir şekilde kaydedildi.";
	}

	function resetOptions($section = "all") {
		$rwcusPanelOptions = get_option("rwcus_" . RWCUS_THEME_SLUG . "_rwcuspanel");
		if ($section == "all") {
			$options = (object)[];
			$optionsToReset = $rwcusPanelOptions;
			$this->outputMessage = "Ayarlar başarılı bir şekilde sıfırlandı.";
		} else {
			$options = $this->getOptions();
			foreach($options as $key => $value) {
				if(str_contains($key, 'catColor') || str_contains($key, 'customColor')) {
					$options->$key = "";
				}
			}
			$optionsToReset[$section] = $rwcusPanelOptions[$section];
			$this->outputMessage = "Bölüm ayarları başarılı bir şekilde sıfırlandı.";
		}
		foreach ($optionsToReset as $key => $value) {
			foreach ($value["data"] as $k => $v) {
				if (isset($k)) {
					$replaces = [
						"{homeurl}" => home_url(),
						"{templateurl}" => get_template_directory_uri(),
						"{adminurl}" => get_admin_url(),
					];
					$default = isset($v["default"]) ? $v["default"] : "";
					$formattedValue = str_replace(array_keys($replaces), array_values($replaces), $default);
					$options->$k = $formattedValue; 
				}
			}
		}
		if ($section == "all" || $section == "social") {
			$socials = $rwcusPanelOptions["social"]["data"]["socials"]["items"];
			if (is_array($socials)) {
				foreach ($socials as $social) {
					if($social != "rss") {
						$options->{$social . "URL"} = "#";
					}
				}
			}
		}
		update_option("rwcus_".RWCUS_THEME_SLUG."_options", json_encode($options, JSON_UNESCAPED_SLASHES));
		$this->matchPages();
	}

	function matchPages() {
		$options = $this->getOptions();
		$args = array(
			'meta_key' => '_wp_page_template',
		);
		$pages = get_pages($args);
		if($pages) {
			foreach($pages as $page) {
				$templateName = get_page_template_slug($page->ID);
				$templateName = preg_replace('/(.*)page-(.*).php(.*)/s', '\2', $templateName);
				if($templateName == "create-post") {
					xoption("addPostsPage", $page->ID);
				}
				if(isset($options->{$templateName . "Page"})) {
					xoption($templateName . "Page", $page->ID);
				}
			}
		}
	}	

	function importOptions() {
		$importedData = $_POST["rwcus_import"];
		json_decode($importedData);
		if(json_last_error() === JSON_ERROR_NONE) {
			$this->outputMessage = "Kodlarda bir sorun olduğu için ayarlar içe aktarılamadı.";
		} else {
			$this->outputMessage = "Ayarlar başarılı bir şekilde içe aktarıldı.";
			update_option("rwcus_" . RWCUS_THEME_SLUG . "_options", stripslashes($importedData));
		}
	}

	function convertOldData() {
		if(is_object($this->getOptions())) return;
		global $wpdb;
		$options = [];
		$oldOptions = $wpdb->get_results( 
			$wpdb->prepare("SELECT option_name FROM " . $wpdb->prefix . "options WHERE option_name LIKE 'rwcus_" . RWCUS_THEME_SLUG . "_%' AND option_name != 'rwcus_" . RWCUS_THEME_SLUG . "_rwcuspanel'") 
		);
		foreach($oldOptions as $oldOption) {
			$optionName = str_replace("rwcus_" . RWCUS_THEME_SLUG . "_", "", $oldOption->option_name);
			$options[$optionName] = get_option("rwcus_" . RWCUS_THEME_SLUG . "_" . $optionName);
		}
		update_option($this->dbField, json_encode($options, JSON_UNESCAPED_SLASHES));
	}
	
}

$rwcuspanel = new RwcusPanel;
$rwcuspanel->showPanel();