<?php

if (!defined("ABSPATH")) {
    exit;
}
$rwcuspanel = new RwcusPanel();
$rwcuspanel->showPanel();
class RwcusPanel
{
    public function __construct()
    {
        $this->dbField = "rwcus_" . RWCUS_THEME_SLUG . "_options";
        $this->handleSubmits();
    }
    public function showPanel()
    {
        add_action("admin_menu", [$this, "adminSidebarMenus"]);
        add_action("admin_enqueue_scripts", [$this, "addScripts"]);
    }
    public function handleSubmits()
    {
        if (is_admin() && current_user_can("administrator") && isset($_GET["page"]) && $_GET["page"] == "rwcuspanel") {
            if (isset($_REQUEST["saveButton"])) {
                $this->saveOptions();
                return NULL;
            }
            if (isset($_REQUEST["resetButton"])) {
                $this->resetOptions();
                return NULL;
            }
            if (isset($_REQUEST["resetSectionButton"])) {
                $this->resetOptions($_REQUEST["activeSection"]);
                return NULL;
            }
            if (isset($_REQUEST["importButton"])) {
                $this->importOptions();
                return NULL;
            }
            if (isset($_REQUEST["hiddenSaveButton"])) {
                $this->saveOptions();
            }
        }
    }
    public function addScripts($hook_suffix)
    {
        if ($hook_suffix == "toplevel_page_rwcuspanel") {
            wp_enqueue_script("media-upload");
            wp_enqueue_script("rwcuspanel", get_template_directory_uri() . "/rwcuspanel/scripts/scripts.js", ["jquery"], filemtime(get_template_directory() . "/rwcuspanel/scripts/scripts.js"), true);
            $editor_settings["codeEditor"] = wp_enqueue_code_editor(["type" => "text/html"]);
            wp_localize_script("jquery", "editor_settings", $editor_settings);
            wp_enqueue_style("rwcuspanel", get_template_directory_uri() . "/rwcuspanel/css/style.css", [], filemtime(get_template_directory() . "/rwcuspanel/css/style.css"));
        }
    }
    public function adminSidebarMenus()
    {
        add_menu_page("RW Panel", "RW Panel", "administrator", "rwcuspanel", [$this, "rwcuspanelPage"]);
        add_submenu_page("rwcuspanel", "Tema Ayarları", "Tema Ayarları", "administrator", "rwcuspanel", [$this, "rwcuspanelPage"]);
        global $rwcusAdminSidebarMenus;
        foreach ($rwcusAdminSidebarMenus as $slug => $data) {
            add_submenu_page("rwcuspanel", $data["name"], $data["name"], "administrator", $slug, $data["func"]);
        }
    }
    public function getOptions()
    {
        return json_decode(get_option($this->dbField));
    }
    public function rwcuspanelPage()
    {
        if (get_option("rwcuspanel_need_update")) {
            rwcusMakeRequest("activation");
            update_option("rwcuspanel_need_update", 0);
        }
        include get_template_directory() . "/lib/rwcustema/rwcusoptions.php";
        echo "\t\t<div class=\"wrap\" id=\"rwcuspanel\" data-sections=\"";
        echo implode(",", array_keys($rwcusOptions));
        echo ",importexport\">\n\t\t\t";
        if (isset($this->outputMessage)) {
            echo "\t\t\t\t<div class=\"updated\">\n\t\t\t\t\t<p>";
            echo $this->outputMessage;
            echo "</p>\n\t\t\t\t</div>\n\t\t\t\t";
            if (function_exists("rwcus_delete_cache")) {
                rwcus_delete_cache();
            }
        }
        echo "\t\n\t\t\t<div id=\"top\">\n\t\t\t\t<div class=\"logo\">\n\t\t\t\t\t<img src=\"";
        echo esc_url(get_template_directory_uri());
        echo "/rwcuspanel/images/logo.png\" width=\"180\" height=\"70\" />\n\t\t\t\t</div>\n\t\t\t\t<div id=\"heading\">\n\t\t\t\t\t<div class=\"arrow\"></div>\n\t\t\t\t\t<div class=\"titles\">\n\t\t\t\t\t\t";
        foreach ($rwcusOptions as $key => $value) {
            echo "\t\t\t\t\t\t\t<div class=\"title\" id=\"rwcuspanel_title_";
            echo $key;
            echo "\">";
            echo $value["title"];
            echo "</div>\n\t\t\t\t\t\t\t";
        }
       echo "\t\t\t\t\t\t<div class=\"title\" id=\"rwcuspanel_title_importexport\">\n\t\t\t\t\t\t\tİçe / Dışa Aktar\t\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</div>\n\t\t\t\t\t<a class=\"help\" target=\"_blank\" title=\"Yardım İçin Bize UIaşın\" href=\"https://www.renatif.com.tr";

        echo "/\">Renatif Web Çözümleri</a>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t<div id=\"rwcuspanelmain\">\n\t\t\t\t<div id=\"rwcuspanelleft\">\n\t\t\t\t\t<ul class=\"rwcusmenu\">\n\t\t\t\t\t\t";
        foreach ($rwcusOptions as $key => $value) {
            echo "\t\t\t\t\t\t\t<li id=\"rwcuspanel_menuitem_";
            echo $key;
            echo "\">\n\t\t\t\t\t\t\t\t<a href=\"#";
            echo $key;
            echo "\" data-hash=\"";
            echo $key;
            echo "\" class=\"";
            echo $key;
            echo "\">\n\t\t\t\t\t\t\t\t\t<span class=\"icon\"></span>\n\t\t\t\t\t\t\t\t\t";
            echo $value["title"];
            echo "\t\t\t\t\t\t\t\t</a>\n\t\t\t\t\t\t\t</li>\n\t\t\t\t\t\t\t";
        }
        echo "\t\t\t\t\t\t<li id=\"rwcuspanel_menuitem_importexport\">\n\t\t\t\t\t\t\t<a href=\"#importexport\" data-hash=\"importexport\" class=\"importexport\">\n\t\t\t\t\t\t\t\t<span class=\"icon\"></span>\n\t\t\t\t\t\t\t\tİçe / Dışa Aktar\n\t\t\t\t\t\t\t</a>\n\t\t\t\t\t\t</li>\n\t\t\t\t\t</ul>\n\t\t\t\t</div>\n\t\n\t\t\t\t<div id=\"rwcuspanelright\">\n\t\t\t\t\t<div id=\"sections\">\n\t\t\t\t\t\t<form method=\"post\" action=\"\">\n\t\t\t\t\t\t\t<div style=\"display: none\">\n\t\t\t\t\t\t\t\t<input type=\"submit\">\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t";
        foreach ($rwcusOptions as $key => $value) {
            echo "\t\t\t\t\t\t\t\t<div class=\"section\" id=\"rwcuspanel_section_";
            echo $key;
            echo "\">\n\t\t\t\t\t\t\t\t\t";
            $datas = $value["data"];
            if (is_array($datas)) {
                foreach ($datas as $key => $value) {
                    include get_template_directory() . "/rwcuspanel/parts/" . $value["type"] . ".php";
                }
            }
            echo "\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t\t";
        }
        echo "\t\t\t\t\t\t\t<div class=\"section\" id=\"rwcuspanel_section_importexport\">\n\t\t\t\t\t\t\t\t<div class=\"rwcuspanelItem aligntop codeeditor\">\n\t\t\t\t\t\t\t\t\t<div class=\"desc\">\n\t\t\t\t\t\t\t\t\t\t<div class=\"title\">İçe Aktar</div>\n\t\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t\t\t<div class=\"infoBox\">Daha önce dışa aktardığınız Rwcuspanel ayarlarına ait metin belgesini yükleyin veya dosya içindeki kodları kopyalayıp buraya yapıştırın. Ardından İçe Aktar butonu ile ayarları yükleyebilirsiniz.</div>\n\t\t\t\t\t\t\t\t\t<div class=\"formitem\">\n\t\t\t\t\t\t\t\t\t\t<textarea name=\"rwcus_import\" id=\"rwcus_import\"></textarea>\n\t\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t\t\t<input id=\"hiddenUploadImportFileButton\" type=\"file\" style=\"display: none\" />\n\t\t\t\t\t\t\t\t\t<input type=\"button\" id=\"uploadImportFileButton\" class=\"button button-primary\" value=\"Dosya Yükle\" style=\"margin-right: 5px\" />\n\t\t\t\t\t\t\t\t\t<input type=\"submit\" id=\"importButton\" name=\"importButton\" class=\"button\" value=\"İçe Aktar\" />\n\t\t\t\t\t\t\t\t</div>\n\n\t\t\t\t\t\t\t\t<div class=\"seperator\"></div>\n\n\t\t\t\t\t\t\t\t<div class=\"rwcuspanelItem aligntop codeeditor\">\n\t\t\t\t\t\t\t\t\t<div class=\"desc\">\n\t\t\t\t\t\t\t\t\t\t<div class=\"title\">Dışa Aktar</div>\n\t\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t\t\t<div class=\"infoBox\">Rwcuspanel ayarlarını Dışa Aktar butonu ile bir metin belgesi olarak dışa aktarabilirsiniz. Daha sonra bu dosya içindeki kodları İçe Aktar bölümü ile tekrar yükleyebilirsiniz. Dışa aktarma son kaydedilen ayarları dışa aktarır.</div>\n\t\t\t\t\t\t\t\t\t<div class=\"formitem\">\n\t\t\t\t\t\t\t\t\t\t<textarea disabled id=\"rwcus_export\" name=\"rwcus_export\">";
        $options = $this->getOptions();
        echo json_encode($options, JSON_UNESCAPED_SLASHES);
        echo "</textarea>\n\t\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t\t\t<input type=\"button\" name=\"exportButton\" class=\"button\" value=\"Dışa Aktar\" data-filename=\"rwcus_";
        echo RWCUS_THEME_SLUG;
        echo "_options\" />\n\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t<p class=\"submit\">\n\t\t\t\t\t\t\t\t<input name=\"hiddenSaveButton\" type=\"hidden\" value=\"1\" />\n\t\t\t\t\t\t\t\t<input name=\"saveButton\" class=\"button button-primary\" type=\"submit\" value=\"Değişiklikleri Kaydet\" />\n\t\t\t\t\t\t\t\t<input name=\"resetButton\" type=\"submit\" class=\"button\" value=\"Tüm Ayarları Sıfırla\" onclick=\"return confirm('Tüm ayarlar varsayılanla sıfırlanacak, devam edilsin mi?')\" />\n\t\t\t\t\t\t\t\t<input name=\"resetSectionButton\" class=\"button\" type=\"submit\" value=\"Bölüm Ayarlarını Sıfırla\" onclick=\"return confirm('Bölüm ayarları varsayılanla sıfırlanacak, devam edilsin mi?')\"  />\n\t\t\t\t\t\t\t\t<input type=\"hidden\" name=\"activeSection\" value=\"general\">\n\t\t\t\t\t\t\t</p>\n\t\t\t\t\t\t</form>\n\t\t\t\t\t</div>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\n\t\t</div>\n\t";
    }
    public function saveOptions()
    {
        $postedOptions = [];
        foreach ($_POST as $key => $value) {
            if (substr($key, 0, strlen(RWCUS_THEME_SLUG)) . "_" === RWCUS_THEME_SLUG . "_") {
                if (is_string($value)) {
                    $value = stripslashes($value);
                }
                $postedOptions[substr($key, strlen(RWCUS_THEME_SLUG) + 1)] = $value;
            }
        }
        if (0 < count($postedOptions)) {
            update_option($this->dbField, json_encode($postedOptions, JSON_UNESCAPED_SLASHES));
        }
        $this->outputMessage = "Ayarlar başarılı bir şekilde kaydedildi.";
    }
    public function resetOptions($section = "all")
    {
        $rwcusPanelOptions = get_option("rwcus_" . RWCUS_THEME_SLUG . "_rwcuspanel");
        if ($section == "all") {
            $options = (object) [];
            $optionsToReset = $rwcusPanelOptions;
            $this->outputMessage = "Ayarlar başarılı bir şekilde sıfırlandı.";
        } else {
            $options = $this->getOptions();
            foreach ($options as $key => $value) {
                if (str_contains($key, "catColor") || str_contains($key, "customColor")) {
                    $options->{$key} = "";
                }
            }
            $optionsToReset[$section] = $rwcusPanelOptions[$section];
            $this->outputMessage = "Bölüm ayarları başarılı bir şekilde sıfırlandı.";
        }
        foreach ($optionsToReset as $key => $value) {
            foreach ($value["data"] as $k => $v) {
                if (isset($k)) {
                    $replaces = ["{homeurl}" => home_url(), "{templateurl}" => get_template_directory_uri(), "{adminurl}" => get_admin_url()];
                    $default = isset($v["default"]) ? $v["default"] : "";
                    $formattedValue = str_replace(array_keys($replaces), array_values($replaces), $default);
                    $options->{$k} = $formattedValue;
                }
            }
        }
        if ($section == "all" || $section == "social") {
            $socials = $rwcusPanelOptions["social"]["data"]["socials"]["items"];
            if (is_array($socials)) {
                foreach ($socials as $social) {
                    if ($social != "rss") {
                        $options->{$social . "URL"} = "#";
                    }
                }
            }
        }
        update_option("rwcus_" . RWCUS_THEME_SLUG . "_options", json_encode($options, JSON_UNESCAPED_SLASHES));
        $this->matchPages();
    }
    public function matchPages()
    {
        $options = $this->getOptions();
        $args = ["meta_key" => "_wp_page_template"];
        $pages = get_pages($args);
        if ($pages) {
            foreach ($pages as $page) {
                $templateName = get_page_template_slug($page->ID);
                $templateName = preg_replace("/(.*)page-(.*).php(.*)/s", "\\2", $templateName);
                if ($templateName == "create-post") {
                    xoption("addPostsPage", $page->ID);
                }
                if (isset($options->{$templateName . "Page"})) {
                    xoption($templateName . "Page", $page->ID);
                }
            }
        }
    }
    public function importOptions()
    {
        $importedData = $_POST["rwcus_import"];
        json_decode($importedData);
        if (json_last_error() === JSON_ERROR_NONE) {
            $this->outputMessage = "Kodlarda bir sorun olduğu için ayarlar içe aktarılamadı.";
        } else {
            $this->outputMessage = "Ayarlar başarılı bir şekilde içe aktarıldı.";
            update_option("rwcus_" . RWCUS_THEME_SLUG . "_options", stripslashes($importedData));
        }
    }
    public function convertOldData()
    {
        if (is_object($this->getOptions())) {
            return NULL;
        }
        global $wpdb;
        $options = [];
        $oldOptions = $wpdb->get_results($wpdb->prepare("SELECT option_name FROM " . $wpdb->prefix . "options WHERE option_name LIKE 'rwcus_" . RWCUS_THEME_SLUG . "_%' AND option_name != 'rwcus_" . RWCUS_THEME_SLUG . "_rwcuspanel'"));
        foreach ($oldOptions as $oldOption) {
            $optionName = str_replace("rwcus_" . RWCUS_THEME_SLUG . "_", "", $oldOption->option_name);
            $options[$optionName] = get_option("rwcus_" . RWCUS_THEME_SLUG . "_" . $optionName);
        }
        update_option($this->dbField, json_encode($options, JSON_UNESCAPED_SLASHES));
    }
}

?>