<?php
if(!defined('ABSPATH')) exit;
$image = "";
if(is_attachment()) {
	$parentID = $post->post_parent;
	$title = get_the_title($parentID);

	$image = get_post_meta($parentID, 'picHeader', true);
	if(!$image) {
		if( xoption("picHeaderFeatured") ) {
			if( has_post_thumbnail($parentID) ) {
				$image = wp_get_attachment_image_src( get_post_thumbnail_id($parentID), 'full');
				$image = $image[0];
			}
		}
	}
	if(!$image) {
		foreach(get_the_category($parentID) as $category) {
			$imageID = get_option("category_" . $category->cat_ID . "_imageID2");
			if($imageID) {
				$imageData = wp_get_attachment_image_src($imageID, 'full');
				if(is_array($imageData)) {
					$image = $imageData[0];
				}
			}
		}
	}

} elseif(is_page() || is_single()) {
	$title = get_the_title();
	$image = get_post_meta(get_the_ID(), 'picHeader', true);
	if(!$image) {
		if( xoption("picHeaderFeatured") ) {
			if( has_post_thumbnail() ) {
				$image = wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'full');
				$image = $image[0];
			}
		}
	}
	if(!$image) {
		foreach(get_the_category() as $category) {
			$imageID = get_option("category_" . $category->cat_ID . "_imageID2");
			if($imageID) {
				$imageData = wp_get_attachment_image_src($imageID, 'full');
				if(is_array($imageData)) {
					$image = $imageData[0];
				}
			}
		}
	}
} elseif(is_category()) {
	$title = single_cat_title("", false);
	$ID = get_query_var('cat');
	$imageID = get_option("category_" . $ID . "_imageID2");
	if($imageID) {
		$imageData = wp_get_attachment_image_src($imageID, 'full');
		if(is_array($imageData)) {
			$image = $imageData[0];
		}
	}
} elseif(is_404()) {
	$title = __('Sayfa Bulunamadı', 'rcza');
} elseif(is_search()) {
	$title = __('Arama Sonuçları', 'rcza');
} elseif(is_tag()) {
	$title = sprintf( __( '%s ile Etiketlenen Konular', 'rcza' ), single_tag_title("", false));
} elseif(is_archive()) {
	$title = get_the_archive_title();
}
if(!$image) $image = xoption('picHeaderImage');
if(!is_home()) :
?>
<div class="picHeader" style="background-image: url(<?php echo $image ?>)">
	<div class="innerContainer">
		<h1 class="title"><?php echo $title; ?></h1>
		<?php if(xoption('breadcrumb')) : ?>
		<div id="rwcuscrumb">
			<?php rwcus_breadcrumb(); ?>
		</div>
		<?php endif; ?>
	</div>
</div>
<?php endif; ?>

<?php if(xoption("showTermDesc") && $x = term_description()) : ?>
	<div class="termDesc">
		<div class="innerContainer">
			<?php echo $x ?>
		</div>
	</div>
<?php endif; ?>
