<?php
if(!defined('ABSPATH')) exit;
/*
	Template Name: Referanslar
*/
?>
<?php get_header(); ?>
<div id="main" class="innerContainer">
	<div id="content">
		<div class="rwcusBox">
			<?php if ( have_posts() ) while ( have_posts() ) : the_post(); ?>
			<div id="referencesPage">
				<div class="reading">
					<div class="rwcusNoGallery"><?php the_content(); ?></div>
				</div>

				<div class="rwcusWidget rwcusCol col<?php echo xoption("refColumn")?>">
					<div class="items">
						<div class="list">
							<?php
							$pageID = get_the_ID();
							$attachmentIDs = rwcus_get_gallery_ids($pageID);

							if(is_array($attachmentIDs)) {
								foreach ( $attachmentIDs as $attachmentID ) {
									$item = get_post($attachmentID); ?>
									<div class="item-container fitImage">
										<div class="item">
											<div class="thumb">
												<?php
												rwcusthumb(array(
													"ID" => $attachmentID,
													"alt" => __('Referans', 'rcza'),
													"class" => "nobg"
												));
												?>
											</div>
											<div class="detail">
												<div class="title"><?php echo $item->post_title ?></div>
												<div class="description"><?php echo $item->post_content ?></div>
											</div>
										</div>
									</div>
									<?php
								}
							}
							?>
						</div>
					</div>
				</div>
			</div>
			<?php endwhile; ?>

			<style>

			#referencesPage .rwcusthumb {
				padding-bottom: var(--refRatio);
			}

			#referencesPage .item-container .item {
				overflow: hidden;
				border: 1px solid #f3f3f3;
				border-radius: 3px;
			}

			#referencesPage .item-container .thumb {
				padding: 10px;
			}

			#referencesPage .item-container .detail {
				padding: 10px;
				background: #f9f9f9;
				text-align: center;
			}

			#referencesPage .item-container .detail .title {
				font-size: 14px;
				font-weight: bold;
			}

			#referencesPage .item-container .detail .description {
				font-size: 12px;
				color: #6f6f6f;
			}

			</style>
		</div>
		<?php if(xoption("pageCommentsActive") && comments_open()) comments_template(); ?>
	</div>
	<?php rwcus_sidebar('page'); ?>
</div>
<?php get_footer(); ?>
