<?php
if(!defined('ABSPATH')) exit;
ob_start("compress");
function compress($buffer) {
	$buffer = preg_replace('!/\*[^*]*\*+([^/][^*]*\*+)*/!', '', $buffer);
	$buffer = str_replace(array(
		"\r\n",
		"\r",
		"\n",
		"\t",
		'  ',
		'    ',
		'    '
	), '', $buffer);
	$buffer = str_replace(' {', '{', $buffer);
	$buffer = str_replace(', ', ',', $buffer);
	$buffer = str_replace(': ', ':', $buffer);
	$buffer = str_replace('; ', ';', $buffer);
	return $buffer;
}
do_action("rwcus_before_style.php");
global $c1; if (!isset($c1)) $c1 = xoption("siteColor");
global $c2; if (!isset($c2)) $c2 = xoption("secondColor");

list($c1r, $c1g, $c1b) = sscanf($c1, "#%02x%02x%02x");
list($c2r, $c2g, $c2b) = sscanf($c2, "#%02x%02x%02x");

$headerHeight = xoption("headerHeight");
if (!is_numeric($headerHeight)) $headerHeight = 40;

$crewRatio = xoption("crewRatio");
if(!is_numeric($crewRatio)) $crewRatio = 0.5625;
$crewRatio *= 100;

$refRatio = xoption("refRatio");
if(!is_numeric($refRatio)) $refRatio = 0.5625;
$refRatio *= 100;

$headerHeightMobile = xoption("headerHeightMobile");
if (!is_numeric($headerHeightMobile)) $headerHeightMobile = 30;

$mobileSingleColumn = xoption("mobileSingleColumn");
if (!is_numeric($mobileSingleColumn)) $mobileSingleColumn = 375;
if ($mobileSingleColumn > 600) $mobileSingleColumn = 599;

$thumbRatio = xoption("thumbRatio");
if (!is_numeric($thumbRatio)) $thumbRatio = 0.5625;
$thumbRatio *= 100;

$catThumbRatio = xoption("catThumbRatio");
if (!is_numeric($catThumbRatio)) $catThumbRatio = 1;
$catThumbRatio *= 100;
?>
<style>
	:root {
		--c1: <?php echo $c1 ?>;
		--c2: <?php echo $c2 ?>;
		--c1RGB: <?php echo "$c1r, $c1g, $c1b" ?>;
		--c2RGB: <?php echo "$c2r, $c2g, $c2b" ?>;
		--headColor: <?php echo xoption("headColor") ?>;
		--linkColor: <?php echo xoption("linkColor") ?>;
		--crewRatio: <?php echo $crewRatio ?>%;
		--refRatio: <?php echo $refRatio ?>%;
		--mainFont: <?php echo xoption("mainFont") ?>, sans-serif;
		--menuFont: <?php echo xoption("menuFont"); ?>, sans-serif;
		--headFont: <?php echo xoption("headFont"); ?>, sans-serif;
		--contentFont: <?php echo xoption("contentFont"); ?>, sans-serif;
		--thumbRatio: <?php echo $thumbRatio ?>%;
		--catThumbRatio: <?php echo $catThumbRatio ?>%;
		--headerHeight: <?php echo $headerHeight ?>px;
		--headerHeightMobile: <?php echo $headerHeightMobile ?>px;
		--noImageForPost: url(<?php echo xoption("noimageforpost") ?>);
	}

	@media all and (max-width:<?php echo $mobileSingleColumn; ?>px) {
		#rwcusPage .rwcusWidget.rwcusCol .items .list .item-container {
			width: 100%;
		}
	}

</style>

<?php ob_end_flush(); ?>
