<?php
if(!defined('ABSPATH')) exit;
if( is_array(xoption('meta')) || xoption('showShareButtons') ) : ?>
<div class="metaBox">
	<div class="metas">
		<?php
		if( is_array(xoption('meta')) ) :
			foreach(xoption('meta') as $meta) {
				switch ($meta) {
					case 'category':
						$cats = get_the_category_list(", ", "");
						if(!$cats)
						$cats = get_the_category_list(", ", "", $post->post_parent);
						if($cats) { ?>
							<div class="meta category">
								<?php themeIcon("category") ?>
								<?php echo $cats; ?>
							</div>
							<?php
						}
					break;
					case 'date':
					?>
						<div class="meta date">
							<?php themeIcon("calendar") ?>
							<?php the_time(xoption("dateFormat")); ?>
						</div>
					<?php
					break;
					case 'hit':
					?>
						<div class="meta hit">
							<?php themeIcon("hit") ?>
							<?php
							if(function_exists('the_views')) {
								$postHit = get_post_meta($post->ID, 'views', true);
							} else {
								$postHit = get_post_meta($post->ID, 'hit',true);
							}
							if(!is_numeric($postHit)) $postHit = 1;
							echo number_format($postHit, 0, '', '.');
							?>
						</div>
					<?php
					break;
					case 'comment':
					?>
						<div class="meta comment">
							<?php themeIcon("comment") ?>
							<a href="<?php the_permalink(); ?>#comments" rel="nofollow">
							<?php comments_number("0", "1", "%"); ?></a>
						</div>
					<?php
					break;
				}
			}
		endif;
		?>
	</div>

	<?php if(xoption('showShareButtons')) : ?>
		<div class="share">
			<a class="facebook" rel="external" href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?>" title="<?php _e("Konuyu Facebook'ta Paylaş", "rcza"); ?>"><?php themeIcon("facebook2") ?></a>
			<a class="twitter" rel="external" href="https://www.twitter.com/share?url=<?php the_permalink(); ?>&amp;text=<?php echo urlencode(get_the_title());?>" title="<?php _e("Konuyu Twitter'da Paylaş", "rcza"); ?>"><?php themeIcon("twitter2") ?></a>
			<a class="whatsapp" rel="external" href="whatsapp://send?text=<?php echo urlencode(get_the_title()) ?>-<?php the_permalink() ?>" title="<?php _e("Konuyu Whatsapp'ta Paylaş", "rcza"); ?>"><?php themeIcon("whatsapp2") ?></a>
		</div>
	<?php endif; ?>
</div>
<?php endif; ?>
