<?php
$snippetJson = [];
global $post;
$faqPost = get_post($post);
$postContent = $faqPost->post_content;
$faqDump = parse_blocks($postContent);
foreach ($faqDump as $block) {
	if($block['blockName'] == "rwcustema/sorucevap") {
        $text = $block['innerHTML'];
        preg_match('/<p class="answer">(.*?)<\/p>/s', $text, $match);
        $snippetJson[] = [
            "@type" => "Question",
            "name" => $block["attrs"]["title"],
            "acceptedAnswer" => [
                "@type" => "Answer",
                "text" => str_replace('"', '', $match[1]),
            ]
        ];
    }
}

if(count($snippetJson) > 0 ) :
?>
<script type="application/ld+json">
{
    "@context": "https://schema.org",
    "@type": "FAQPage",
    "mainEntity": [
        <?php echo json_encode($snippetJson); ?>
    ]
}
</script>
<?php endif; ?>
