jQuery(document).ready(function($) {

	// CATEGORY SELECT
		
		$('select.categorySelect').each(function () {
			if($(this).val() == 'include' || $(this).val() == 'exclude') {
				$(this).next().show();
			} else {
				$(this).next().hide();
			}
		});

		$(document).on('change', 'select.categorySelect', function(){
			if($(this).val() == 'include' || $(this).val() == 'exclude') {
				$(this).next().show();
			} else {
				$(this).next().hide();
			}
		});

	
		$("body").on("click", ".rwcusWidgetItem .selectButtons .selectAll", function() {
			$(this).closest(".rwcusWidgetItem").find('input[type=checkbox]').prop('checked', true).trigger( 'change' );
		});

		$("body").on("click", ".rwcusWidgetItem .selectButtons .selectNone", function() {
			$(this).closest(".rwcusWidgetItem").find('input[type=checkbox]').prop('checked', false).trigger( 'change' );
		});
		
	// ICON SELECTOR
		
		$("body").on("focus", ".rwcusAdminIconSelector .iconInput", function() {
			$(this).closest(".rwcusAdminIconSelector").find(".iconList").slideDown()
			$(this).closest(".rwcusAdminIconSelector").find(".iconList .item").show()
		});
	
		$("body").on("click", ".rwcusAdminIconSelector .iconList .close", function() {
			$(this).closest(".rwcusAdminIconSelector .iconList").slideUp();
		});
	
		$("body").on("click", ".rwcusAdminIconSelector .iconList .item", function() {
			var val = $(this).attr("data-icon");
			var mainDiv = $(this).closest(".rwcusAdminIconSelector");
			
			mainDiv.find(".iconList .item").removeClass("active");
			$(this).addClass("active");
			mainDiv.find(".iconList").slideUp();
	
			mainDiv.find(".iconInput").val(val).trigger('change');
			mainDiv.find(".iconSelected .rwcusicon").find("use").attr("href", "#rwcusicon-" + val);
		});
	
		$("body").on("keyup", ".rwcusAdminIconSelector .iconInput", function() {
			var val = $(this).val();
			var mainDiv = $(this).closest(".rwcusAdminIconSelector");
			// selectedIcon Element
			mainDiv.find(".iconSelected .rwcusicon").removeClass().addClass("rwcusicon " + val).find("use").attr("href", "#rwcusicon-" + val);
			// Icons Div Search Phrase
			if (val != "") {
				mainDiv.find(".iconList .item").hide()
				mainDiv.find('.iconList .item[data-icon*="'+val+'"]').show()
			} else {
				mainDiv.find(".iconList .item").show()
			}
			// Icons Div Activate Icon
			mainDiv.find(".iconList .item").removeClass("active")
			mainDiv.find('.iconList .item[data-icon="'+val+'"]').addClass("active")
		});
	
	
	// WIDGETS
	
		$("body").on("click", ".rwcusWidgetBox .title", function() {
			$(this).parent().toggleClass("active");
			$(this).next().slideToggle();
		});
		$("body").on("click", "a.showAllBoxes", function(e) {
			e.preventDefault();
			$(this).closest(".widget-content").find(".rwcusWidgetBox").addClass("active").find(".data").slideDown();
		});
		$("body").on("click", "a.hideAllBoxes", function(e) {
			e.preventDefault();
			$(this).closest(".widget-content").find(".rwcusWidgetBox").removeClass("active").find(".data").slideUp();
		});
	
	// COLORS
		
		function initColorPicker( widget ) {
			widget.find( '.color-picker' ).wpColorPicker( {
				change: _.throttle( function() { // For Customizer
					$(this).trigger( 'change' );
				}, 3000 )
			});
		}
	
		function onFormUpdate( event, widget ) {
			initColorPicker( widget );
		}
	
		$( document ).on( 'widget-added widget-updated', onFormUpdate );
	
		$( document ).ready( function() {
			$( '#widgets-right .widget:has(.color-picker)' ).each( function () {
				initColorPicker( $( this ) );
			} );
		});
		
	});
	