<?php
if(!defined('ABSPATH')) exit;

// READING OPTIONS
	if(get_option('posts_per_page') == 10) update_option('posts_per_page', 18);
	update_option("show_on_front", "posts");

// UPLOAD DEFAULT IMAGES
	$files = [
		"rwcusaboutimage" =>get_template_directory_uri() . "/images/aboutimage.jpg",
		"rwcussloganimage" =>get_template_directory_uri() . "/images/sloganimage.jpg",
	];
	global $wp_filesystem;
	foreach($files as $name => $file) {
		$filename = basename($file);
		$upload_file = wp_upload_bits($filename, null, $wp_filesystem->get_contents($file));
		if (!$upload_file['error']) {
			$wp_filetype = wp_check_filetype($filename, null );
			$attachment = array(
				'post_mime_type' => $wp_filetype['type'],
				'post_title' => preg_replace('/\.[^.]+$/', '', $filename),
				'post_content' => '',
				'post_status' => 'inherit'
			);
			$attachment_id = wp_insert_attachment( $attachment, $upload_file['file'] );
			if (!is_wp_error($attachment_id)) {
				require_once(ABSPATH . "wp-admin" . '/includes/image.php');
				$attachment_data = wp_generate_attachment_metadata( $attachment_id, $upload_file['file'] );
				wp_update_attachment_metadata( $attachment_id,  $attachment_data );
				update_option($name, $attachment_id);
			}
		}
	}

// PAGES
$pages = array(
	'contact'	=> __('İletişim', 'rcza'),
);
foreach ($pages as $key => $value) {
	if(get_page_by_title($value) == null) {
		$post_id = wp_insert_post(
			array(
				'post_title'    =>  $value,
				'post_status'   =>  'publish',
				'post_type'     =>  'page'
			)
		);
		update_post_meta($post_id, "_wp_page_template", "pages/page-" . $key . ".php");
	}
}

// MENUS
$menuItems = wp_get_nav_menus();
if(count($menuItems) > 0) {
	$menus = array();
} else {
	$menus = array(
		'mainmenu'		=>	'Ana Menü',
		'mobilemenu'	=>	'Mobil Menü',
	);
}
foreach ($menus as $menulocation => $menuname) {
	$menu_exists = wp_get_nav_menu_object( $menuname );
	if( !$menu_exists) {
		$menu_id = wp_create_nav_menu($menuname);
		if( !has_nav_menu( $menulocation ) ) {
			$locations = get_theme_mod('nav_menu_locations');
			$locations[$menulocation] = $menu_id;
			set_theme_mod( 'nav_menu_locations', $locations );
			wp_update_nav_menu_item($menu_id, 0, array(
				'menu-item-title' =>  'Menüye Eleman Ekleyiniz',
				'menu-item-url' => home_url('wp-admin/nav-menus.php?action=edit&menu=' . $menu_id),
				'menu-item-status' => 'publish')
			);
		}
	}
}
