<?php if(!defined('ABSPATH')) exit; ?>
<?php
function rwcus_metabox_data() {
	$metaboxes = [
		
		"picHeader" => [
			"type" => "image",
			"text" => 'Arkaplanlı Başlık için Görsel Adresi',
		],
	];
	$metaboxes = apply_filters( 'rwcusGetMetaboxes', $metaboxes );
	return $metaboxes;
}

function rwcus_add_meta_box() { 
	add_meta_box(
		'custom_post_metabox',
		'Diğer Ayarlar',
		'rwcus_display_meta_box',
		['post', 'page'],
		'normal',
		'core'
	);
}
add_action( 'add_meta_boxes', 'rwcus_add_meta_box' );
	
function rwcus_display_meta_box( $post ) {
	wp_nonce_field( plugin_basename(__FILE__), 'rwcus_nonce_field' );
	$metaboxes = rwcus_metabox_data();
	foreach($metaboxes as $metabox => $data) {
		$currentValue = "";
		switch($data['type']) {
			case "text" :
				$currentValue = get_post_meta( $post->ID, $metabox, true );
				?>
				<p><?php echo $data['text'] ?></p>
				<input type="text" class="widefat" name="<?php echo $metabox ?>" value="<?php echo $currentValue ?>" />
				<?php
			break;
			case "textarea" :
				$currentValue = get_post_meta( $post->ID, $metabox, true );
				?>
				<p><?php echo $data['text'] ?></p>
				<textarea class="widefat" name="<?php echo $metabox ?>"><?php echo $currentValue ?></textarea>
				<?php
			break;
			case "image" :
				$currentValue = get_post_meta( $post->ID, $metabox, true );
				?>
				<p><?php echo $data['text'] ?></p>
				<div class="imageButtonContainer metabox">
					<div class="container">
						<input class="widefat" type="text" name="<?php echo $metabox ?>" value="<?php echo $currentValue ?>" />
						<a class="button mediaButton select URL">Resim Seç</a>
					</div>
					<img class="metaboxImage" src="<?php echo $currentValue?>">
				</div>
				<?php
			break;
		}
	}
}
	
function rwcus_save_meta_box_data( $post_id ) {
	if ( rwcus_user_can_save( $post_id, 'rwcus_nonce_field' ) ) {
		$metaboxes = rwcus_metabox_data();
		foreach($metaboxes as $metabox => $data) {
			if ( isset( $_POST[$metabox] ) ) {
				$value = stripslashes( strip_tags( $_POST[$metabox] ) );
				if($value == "") {
					delete_post_meta( $post_id, $metabox, $value );
				} else {
					update_post_meta( $post_id, $metabox, $value );
				}
			}	
		}
	}
}
add_action( 'save_post', 'rwcus_save_meta_box_data' );
			
function rwcus_user_can_save( $post_id, $nonce ) {
	$is_autosave = wp_is_post_autosave( $post_id );
	$is_revision = wp_is_post_revision( $post_id );
	$is_valid_nonce = ( isset( $_POST[ $nonce ] ) && wp_verify_nonce( $_POST [ $nonce ], plugin_basename( __FILE__ ) ) );
	return ! ( $is_autosave || $is_revision ) && $is_valid_nonce;	 
}



// Attachment Metas

function be_attachment_field_credit( $form_fields, $post ) {
	$form_fields['position'] = array(
		'label' => 'Ünvan',
		'input' => 'text',
		'value' => get_post_meta( $post->ID, 'position', true ),
	);
	$form_fields['facebook'] = array(
		'label' => 'Facebook',
		'input' => 'text',
		'value' => get_post_meta( $post->ID, 'facebook', true ),
	);
	$form_fields['instagram'] = array(
		'label' => 'Instagram',
		'input' => 'text',
		'value' => get_post_meta( $post->ID, 'instagram', true ),
	);
	$form_fields['twitter'] = array(
		'label' => 'Twitter',
		'input' => 'text',
		'value' => get_post_meta( $post->ID, 'twitter', true ),
	);
	$form_fields['linkedin'] = array(
		'label' => 'Linkedin',
		'input' => 'text',
		'value' => get_post_meta( $post->ID, 'linkedin', true ),
	);

	return $form_fields;
}

add_filter( 'attachment_fields_to_edit', 'be_attachment_field_credit', 10, 2 );

function be_attachment_field_credit_save( $post, $attachment ) {
	if( isset( $attachment['position'] ) )
		update_post_meta( $post['ID'], 'position', $attachment['position'] );
	if( isset( $attachment['facebook'] ) )
		update_post_meta( $post['ID'], 'facebook', $attachment['facebook'] );
	if( isset( $attachment['instagram'] ) )
		update_post_meta( $post['ID'], 'instagram', $attachment['instagram'] );
	if( isset( $attachment['twitter'] ) )
		update_post_meta( $post['ID'], 'twitter', $attachment['twitter'] );
	if( isset( $attachment['linkedin'] ) )
		update_post_meta( $post['ID'], 'linkedin', $attachment['linkedin'] );

	return $post;
}

add_filter( 'attachment_fields_to_save', 'be_attachment_field_credit_save', 10, 2 );

// Category Meta

add_action ( 'edit_category_form_fields', 'rwcus_edit_category_image');

function rwcus_edit_category_image( $tag ) {
	$t_id = $tag->term_id;
	$catImage1 = get_option("category_".$t_id."_imageID1");
	$catImage2 = get_option("category_".$t_id."_imageID2");
	?>

	<tr class="form-field">
		<th scope="row">
			<label for="catImage1">Kategori Resim 1</label>
			<div style="font-size: smaller; margin-top:5px; font-weight:normal;">Resimli kategoriler bileşeni için bir resim seçiniz.</div>
		</th>
		<td>
			<div class="imageButtonContainer">
				<input class="cat_image_url" name="catImage1" id="catImage1" type="hidden" value="<?php echo $catImage1 ? $catImage1 : ''; ?>">
				<?php if($catImage1) : ?>
					<img style="display:block; max-width: 100%; padding:10px; margin-top:10px; background:#ddd" src="<?php echo wp_get_attachment_url($catImage1) ?>">
				<?php else: ?>
					<img style="display:none; max-width: 100%; padding:10px; margin-top:10px; background:#ddd" src="">
				<?php endif; ?>
				<div class="buttons">
					<a class="button mediaButton select">Resim Seç</a>
					<a class="button mediaButton remove" <?php if(!$catImage1) echo "style=display:none"?>>Resmi Sil</a>
				</div>
			</div>
		</td>
	</tr>
	<tr class="form-field">
		<th scope="row">
			<label for="catImage1">Kategori Resim 2</label>
			<div style="font-size: smaller; margin-top:5px; font-weight:normal;">Kategori sayfasındaki resimli başlık için bir resim seçiniz. (Boş bırakırsanız rwcuspanelde belirttiğiniz varsayılan görsel kullanılacaktır.)</div>
		</th>
		<td>
			<div class="imageButtonContainer">
				<input class="cat_image_url" name="catImage2" id="catImage2" type="hidden" value="<?php echo $catImage2 ? $catImage2 : ''; ?>">
				<?php if($catImage2) : ?>
					<img style="display:block; max-width: 100%; padding:10px; margin-top:10px; background:#ddd" src="<?php echo wp_get_attachment_url($catImage2) ?>">
				<?php else: ?>
					<img style="display:none; max-width: 100%; padding:10px; margin-top:10px; background:#ddd" src="">
				<?php endif; ?>
				<div class="buttons">
					<a class="button mediaButton select">Resim Seç</a>
					<a class="button mediaButton remove" <?php if(!$catImage2) echo "style=display:none"?>>Resmi Sil</a>
				</div>
			</div>
		</td>
	</tr>

	<?php
}

add_action ( 'edited_category', 'rwcus_save_category_image');

function rwcus_save_category_image( $term_id ) {
	$t_id = $term_id;
	if (isset($_POST['catImage1'])) {
		update_option("category_".$t_id."_imageID1", $_POST['catImage1']);
	}
	if (isset($_POST['catImage2'])) {
		update_option("category_".$t_id."_imageID2", $_POST['catImage2']);
	}
}