<?php if(!defined('ABSPATH')) exit; ?>
<?php

add_action('init', 'register_my_menus');
function register_my_menus() {
	register_nav_menus(array('mainmenu'=>'Ana Menü'));
	register_nav_menus(array('mobilemenu'=>'Mobil Menü'));
}

function rwcus_nav_menu($theme_location) {
	$menu = wp_nav_menu( array(
		'theme_location'	=> $theme_location,
		'container'			=> 'ul',
		'fallback_cb'		=> false,
		'walker'			=> new rwcIconMenuWalker(),
		'echo'				=> 0
	) );
	return $menu;
	
}

// Walkers

class rwcIconMenuWalker extends Walker_Nav_Menu {
	function start_el(&$output, $item, $depth = 0, $args = Array(), $id = 0) {
		global $wp_query;
		$indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';
		$class_names = $value = '';
		$classes = empty( $item->classes ) ? array() : (array) $item->classes;
		$class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item ) );
		$class_names = ' class="' . esc_attr( $class_names ) . '"';
		$output .= $indent . '<li ' . $value . $class_names .'>';
		$attributes  = ! empty( $item->attr_title ) ? ' title="'  . esc_attr( $item->attr_title ) .'"' : '';
		$attributes .= ! empty( $item->target )     ? ' target="' . esc_attr( $item->target     ) .'"' : '';
		$attributes .= ! empty( $item->xfn )        ? ' rel="'    . esc_attr( $item->xfn        ) .'"' : '';
		$attributes .= ! empty( $item->url )        ? ' href="'   . esc_attr( $item->url        ) .'"' : '';

		$rwc_menu_icon = "";
		$rwc_menu_icon = get_post_meta( $item->ID, '_menu_item_rwc_menu_icon', true );
		global $rwcusIcons;
		if(in_array($rwc_menu_icon, $rwcusIcons)) {
			$rwc_menu_icon = rwcusIcon($rwc_menu_icon, false);
		} elseif(count($classes) > 0) {
			if($classes[0] != "menu-item" && in_array($classes[0], $rwcusIcons)) {
				$rwc_menu_icon = rwcusIcon($classes[0], false);
			} else {
				$rwc_menu_icon = "";
			}
		}
		
		$item_output = $args->before;
		$item_output .= '<a'. $attributes .'>'.$rwc_menu_icon.'<div class="text">';
		$item_output .= $args->link_before . apply_filters( 'the_title', $item->title, $item->ID ) . $args->link_after;
		$item_output .= '</div>';
		if($args->walker->has_children) {
			$item_output .= themeIcon("arrow", false);
		}
		$item_output .= '</a>';
		$item_output .= $args->after;

		$output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
	}
}
