<?php if(!defined('ABSPATH')) exit; ?>
<?php
function rwcus_scripts_and_styles() {

	rwcus_enqueue_style('rwcusstyle', 'style.css');
	if(file_exists(get_template_directory() . '/edits/style.css')) {
		rwcus_enqueue_style('rwcuscustomstyle', 'edits/style.css');
	}

	global $rwcusSelectedFonts;
	foreach ($rwcusSelectedFonts as $font => $typekit) {
		wp_enqueue_style('rwcus'.$font.'font', 'https://use.typekit.net/'.$typekit.'.css');
	}

	wp_enqueue_script( 'jquery' );
	rwcus_enqueue_script('owl', 'lib/owl-carousel/owl.carousel.min.js');
	rwcus_enqueue_script( 'rwc_kurumsalscripts', 'scripts/scripts.js');
	if(file_exists(get_template_directory() . '/edits/scripts.js')) {
		rwcus_enqueue_script('rwcuscustomscript', 'edits/scripts.js');
	}

	if(xoption("rwcusLightbox")) {
		rwcus_enqueue_script('fancybox', 'lib/fancybox/jquery.fancybox.min.js');
		rwcus_enqueue_style('fancybox', 'lib/fancybox/jquery.fancybox.min.css');
	}
}

add_action( 'wp_enqueue_scripts', 'rwcus_scripts_and_styles' );
