<?php if(!defined('ABSPATH')) exit; ?>
<?php
// Widget Page
if (function_exists('register_sidebar')) {
	$args = array(
		'meta_key' => '_wp_page_template',
		'meta_value' => 'pages/page-widget.php'
	);
	$pages = get_pages($args);
	if($pages) {
		foreach($pages as $page) {
			register_sidebar(array(
				'name'=>'Sayfa: ' . $page->post_title,
				'id'=>'sayfa-' . $page->ID,
				'before_widget'=>'<div class="homeWidget nativeWidget rwcusWidget"><div class="widgetContent">',
				'after_widget'=>'</div></div>',
				'before_title'=>'<div class="widgetHeading"><div class="inner"><div class="text">',
				'after_title'=>'</div></div></div>',
				'description'=>'Sayfa bileşenlerini buraya ekleyiniz.'
			));
		
		}
	}
}



// Remove generator meta tag
	remove_action('wp_head', 'wp_generator');

// rwcusthumb

	function rwcusthumb($data = array("type" => "post", "ID" => 0, "alt" => "", "class" => '')) {
		extract($data);

		// Post Defaults
		if(isset($type) && $type == "post") {
			if($ID == 0) $ID = get_post_thumbnail_id();
			if($alt == "") $alt = get_the_title();
		} else {
			if(!isset($type)) $type = "";
			if(!isset($ID)) $ID = 0;
			if(!isset($alt)) $alt = get_bloginfo("name");
			if(!isset($class)) $class = "";
		}

		$imageData = wp_get_attachment_image_src($ID, 'large');
		if(is_array($imageData)) {
			$image = $imageData[0];
			$width = $imageData[1];
			$height = $imageData[2];
		} else {
			$image = xoption("noimageforpost");
			$width = 160;
			$height = 90;
		}
		?>
		<div class="rwcusthumb <?php echo $class ?>">
			<div class="thumbnail">
				<div class="center">
					<img <?php rwcusLazyThumb($image) ?> alt="<?php echo $alt ?>" width="<?php echo $width ?>" height="<?php echo $height ?>" />
				</div>
			</div>
		</div>
		<?php
	}

	function rwcusLazyThumb($image) {
		if(xoption("lazyload")) {
			echo 'src="' . xoption("noimageforpost") . '" data-src="' . $image . '" class="lazy" loading="lazy"';
		} else {
			echo 'src="' . $image . '"';
		}
	}

// Rwcus Top Category
	function rwcus_top_category($catID) {
		$curr_cat = get_category_parents($catID, false, '/' ,true);
		$curr_cat = explode('/',$curr_cat);
		$idObj = get_category_by_slug($curr_cat[0]);
		return $idObj->term_id;
	}

// Bracket Remover

	function rwcusBracket($x) {
		$active = false;
		$result = "";
		$len = strlen($x);
		if($len>1) {
			for ($i=0; $i<=$len-1; $i++) {
				if(substr($x, $i, 1) == '[') {
					$active = true;
				}
				elseif (substr($x, $i, 1) == "]") {
					$active = false;
				}
				if($active == false && substr($x, $i, 1) != "]") {
					$result .= substr($x, $i, 1);
				}
			}
			return $result;
		}
	}

// Custom Functions

	function rwcusText($wordsCount, $echo = true, $excerpt = true) {
		global $post;
		if($excerpt && $x = get_the_excerpt()) :
			$string = rwcusBracket(strip_tags($x));
		else :
			$string = rwcusBracket(strip_tags(get_the_content()));
		endif;
		$array = explode(" ", $string);
		if (count($array)>$wordsCount) :
			array_splice($array, $wordsCount);
			$string = implode(" ", $array)."...";
		endif;
		if($echo) :
			echo $string;
		else :
			return $string;
		endif;
	}

	function rwcusText2($content, $wordsCount) {
		$string = rwcusBracket(strip_tags($content));
		$array = explode(" ", $string);
		if (count($array)>$wordsCount) :
			array_splice($array, $wordsCount);
			$string = implode(" ", $array)."...";
		endif;
		echo $string;
	}

// JS Valid

	add_filter('style_loader_tag', 'rwcus_remove_type_attr', 10, 2);
	add_filter('script_loader_tag', 'rwcus_remove_type_attr', 10, 2);

	function rwcus_remove_type_attr($tag, $handle) {
		return preg_replace( "/type=['\"]text\/(javascript|css)['\"]/", '', $tag );
	}

// RWCUS ICONS

	function rwcusIcon($icon = "icon1", $echo = true) {
		$icon = str_replace("icon:", "", $icon);
		if($echo) {
			echo '<span class="rwcusicon icon"><svg class="rwcusicon-'.$icon.'"><use href="#rwcusicon-'.$icon.'"></use></svg></span>';
		} else {
			return '<span class="rwcusicon icon"><svg class="rwcusicon-'.$icon.'"><use href="#rwcusicon-'.$icon.'"></use></svg></span>';
		}
	}

	function themeIcon($icon = "icon1", $echo = true) {
		if($echo) {
			echo '<span class="themeicon icon"><svg class="themeicon-'.$icon.'"><use href="#themeicon-'.$icon.'"></use></svg></span>';
		} else {
			return '<span class="themeicon icon"><svg class="themeicon-'.$icon.'"><use href="#themeicon-'.$icon.'"></use></svg></span>';
		}
	}

	function rwcusPrice() {
		if($discount = get_post_meta(get_the_ID(), "indirimlifiyat", true)) :
			?>
			<div class="postprice">
				<span><?php echo get_post_meta(get_the_ID(), "fiyat", true) ?></span>
				<?php echo $discount; ?>
			</div>
		<?php
		elseif($price = get_post_meta(get_the_ID(), "fiyat", true)) :
			?>
			<div class="postprice">
				<?php echo $price; ?>
			</div>
		<?php
		endif;
	}
	
	function rwcus_sidebar($sidebar = "general") {
		?>
		<?php if( (wp_is_mobile() && xoption('hideMobileSidebar')) == false && xoption("sidebarPosition") != "noSidebar" ) : ?>
		<aside id="aside">
		<?php global $widgetPlace; $widgetPlace = "sidebar"; ?>
		<div id="panels">
			<?php
			if(is_active_sidebar('sidebar-' . $sidebar)) :
				dynamic_sidebar('sidebar-' . $sidebar);
			else:
				dynamic_sidebar('sidebar-general');
			endif;
			?>
		</div>
		</aside>
		<?php endif; ?>
		<?php
	}

function rwcus_icons_for_widgets($content) {
	$new_content = preg_replace("/(icon:\w+)/", "<div class=\"rwcusicon icon\"><svg class=\"rwcusicon-$1\"><use xlink:href=\"#rwcusicon-$1\"></use></svg></div>", $content);
	$new_content = str_replace("rwcusicon-icon:", "rwcusicon-", $new_content);
	return $new_content;
}

add_filter('widget_text', 'rwcus_icons_for_widgets');
add_filter('widget_title', 'rwcus_icons_for_widgets');

function rwcusAdminIconSelector($name, $icon) {
	$id = str_replace(["[", "]"], ["-", ""], $name);
	?>
	<div class="rwcusAdminIconSelector">
		<div class="iconSelected">
			<?php rwcusIcon($icon); ?>
		</div>
		<input class="iconInput" autocomplete="off" name="<?php echo $name; ?>" id="<?php echo $id; ?>" type="text" value="<?php if ($x = $icon) echo($x); ?>" />
		<div class="iconList" style="display:none;">
			<div class="close">X</div>
			<?php
			global $rwcusIcons;
			foreach($rwcusIcons as $k) { ?>
				<div class="item <?php if($k == $icon) { echo 'active'; } ?>" data-icon="<?php echo $k; ?>">
					<div class="inner">
						<?php rwcusIcon($k); ?>
					</div>
				</div>
			<?php } ?>
		</div>
	</div>
	<?php
}

// Rwcus Gallery IDs

function rwcus_get_gallery_ids($pageID) {
	$attachmentIDs = "";

	if (function_exists("has_block")) {
		$galleryPost = get_post($pageID);
		$galleryContent = $galleryPost->post_content;
		$galleryDump = parse_blocks($galleryContent);
		foreach ($galleryDump as $block) {
			if($block['blockName'] == "core/gallery") {
				$text = $block['innerHTML'];
				preg_match_all('@data-id="(.*?)"@si', $text, $content);
				if(is_array($content[1])) $attachmentIDs = $content[1];
				if(isset($block["attrs"]["ids"])) $attachmentIDs = $block["attrs"]["ids"];
			}
		}
		if(is_array($attachmentIDs)) {
			if(count($attachmentIDs) == 0 || !is_numeric(array_values($attachmentIDs)[0])) {
				$attachmentIDs = [];
				foreach ($galleryDump as $block) {
					if($block['blockName'] == "core/gallery") {
						foreach ($block["innerBlocks"] as $innerBlock) {
							if(is_numeric($innerBlock["attrs"]["id"])) $attachmentIDs[] = $innerBlock["attrs"]["id"];
						}
					}
				}	
			}
		}
	}

	if(!is_array($attachmentIDs)) {
		$gallery = get_post_gallery( $pageID, false );
		if($gallery) {
			$attachmentIDs = explode(',', $gallery['ids']);
		}
	}

	return $attachmentIDs;
}

// Register Scripts and Styles

	function rwcus_enqueue_style($name, $file) {
		wp_enqueue_style($name, get_template_directory_uri() . '/' . $file, [], filemtime(get_template_directory() . "/" . $file));
	}
	
	function rwcus_enqueue_script($name, $file) {
		wp_enqueue_script($name, get_template_directory_uri() . '/' . $file, ['jquery'], filemtime(get_template_directory() . '/' . $file), true );
	}
	
	function rwcus_register_script($name, $file) {	
		wp_register_script($name, get_template_directory_uri() . '/' . $file, ['jquery'], filemtime(get_template_directory() . '/' . $file), true );
	}

	
// Rwcus Logo

	function rwcusLogo() {
		?>
		<a class="rwcus-logo" href="<?php bloginfo('url'); ?>">
			<?php if($x = xoption("logo")) : ?>
				<img src="<?php echo $x; ?>" alt="<?php bloginfo('name'); ?>" title="<?php bloginfo('name'); ?> - <?php _e("Anasayfa", "rcza") ?>" width="<?php echo xoption('logoWidth'); ?>" height="<?php echo xoption('logoHeight'); ?>" />
			<?php else: ?>
				<?php bloginfo('name'); ?>
			<?php endif; ?>
		</a>
		<?php
	}

// Update Hit
	function rwcusUpdateHit() {
		if(!is_admin() && (is_single() || is_attachment() || is_page())) {
			$id = get_the_ID();
			$postHit = get_post_meta($id, 'hit',true);
			if(is_numeric($postHit)) {
				$postHit++;
			} else {
				$postHit = 1;
			}
			update_post_meta($id, 'hit', $postHit);
		}
	}
	add_action('template_redirect', 'rwcusUpdateHit');