<?php if(!defined('ABSPATH')) exit; ?>
<?php
add_filter( 'body_class','rwcus_body_classes' );
function rwcus_body_classes( $classes ) {
	if(wp_is_mobile()) {
		$classes[] = 'mobile';
		if(xoption("mobileStickyMenu")) $classes[] = 'stickyMenu';
	} else {
		$classes[] = 'desktop';
		if(xoption("desktopStickyMenu")) $classes[] = 'stickyMenu';
	}
	if(xoption("fitImage")) $classes[] = "fitImage";
	$classes[] = xoption('sidebarPosition');
	if(!in_array("headerOver", $classes) && !in_array("headerColored", $classes) && !in_array("headerWhite", $classes)) $classes[] = xoption('headerDesign');
	return $classes;
}

add_action( 'rwcus_body_tag', 'rwcus_body_tag_mobile_column' );
function rwcus_body_tag_mobile_column() {
	body_class();
	if(is_numeric(xoption("mobileSingleColumn"))) {
		$singleColValue = xoption("mobileSingleColumn") + 1;
	} else {
		$singleColValue = 376;
	}
	echo ' data-mobileSingleColumn="' . $singleColValue . '"';
}

// HEAD AND BODY TAGS

add_action("wp_body_open", "rwcus_openbody_tag");
add_action("admin_head", "rwcus_admin_head");
function rwcus_openbody_tag() {
	echo xoption("bodyOpenScript");
	include(get_template_directory() . "/images/icons.svg");
	include(get_template_directory() . "/images/sprite.svg");
}
function rwcus_admin_head() {
	global $rwcusIcons;
	include(get_template_directory() . "/images/icons.svg");
	include(get_template_directory() . "/images/sprite.svg");
	include(get_template_directory() . "/lib/rwcustema/style.php");
}

add_action("wp_head", "rwcus_head_tag");
function rwcus_head_tag() {
	?>
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
	<meta charset="<?php bloginfo('charset'); ?>" />
	<link rel="shortcut icon" href="<?php echo xoption('favicon') ?>">
	<?php if(is_single()) wp_enqueue_script('comment-reply'); ?>
	<!--[if lt IE 9]><script src="<?php echo esc_url(get_template_directory_uri()) ?>/scripts/html5shiv.js"></script><![endif]-->
	<?php
	if(is_singular() && has_block("rwcustema/sorucevap")) {
		include(get_template_directory() . "/lib/rwcustema/faqsnippet.php");
	}
	echo xoption('headerScript');
	echo xoption('gaScript');
	include(get_template_directory() . "/lib/rwcustema/style.php");
}


