<?php if(!defined('ABSPATH')) exit; ?>
<?php
function rwc_admin_enqueue() {
	wp_enqueue_media();

	rwcus_register_script( 'rwcusadmin', 'lib/rwcustema/assets/admin.js');
	rwcus_register_script( 'meta-box-image', 'rwcuspanel/scripts/image.js');
	wp_localize_script( 'meta-box-image', 'meta_image',
		array(
			'title' => 'Bir Resim Seçin veya Bilgisayarınızdan Yükleyin',
			'button' => 'Bu Resmi Kullan',
		)
	);
	wp_enqueue_script( 'meta-box-image' );
	wp_enqueue_script( 'wp-color-picker' );
	wp_enqueue_script( 'rwcusadmin' );
}
add_action( 'admin_enqueue_scripts', 'rwc_admin_enqueue' );

function rwcus_admin_styles() {
	rwcus_enqueue_style("rwcusadmin", "lib/rwcustema/assets/admin.css");
	wp_enqueue_style("wp-color-picker");
}

add_action('admin_print_styles', 'rwcus_admin_styles');
if(current_user_can("administrator") && is_admin_bar_showing()) {
	add_action('wp_enqueue_scripts', 'rwcus_admin_styles');
}

function rwcus_admin_fonts() {
	global $rwcusFonts;
	$customFonts = $rwcusFonts["custom-fonts"];
	foreach ($customFonts as $font => $typekit) {
		wp_enqueue_style('rwcus-'.$font.'-font', 'https://use.typekit.net/'.$typekit.'.css');
	}
}
add_action('admin_print_styles', 'rwcus_admin_fonts');
