<?php

if (!defined("ABSPATH")) {
    exit;
}
$YASAL_UYARI = "\n\t\tFirmamız vergi levhasına sahip ve faturalı olarak satış yapan bir firmadır. Rcza Wordpress Teması Niğde 3.Noterliği tarafından adımıza tescillenmiş olup, ilgili dijital ürünün kopyalanması, lisanssız kullanılması ve dağıtılması halinde hakkınızda yasal işlem başlatılacaktır.";
if (!defined("RWCUS_THEME_SLUG")) {
    define("RWCUS_THEME_SLUG", "rcza");
}
include_once get_template_directory() . "/rwcuspanel/index.php";
global $rwcuspanel;
$rwcuspanel->convertOldData();
global $wp_filesystem;
if (empty($wp_filesystem)) {
    require_once ABSPATH . "/wp-admin/includes/file.php";
    WP_Filesystem();
}
add_action("admin_bar_menu", "rwcusAdminBarMenu", 400);
$rwcusStatus = "checked";
rwcuscheckstatus();
if (!defined("IS_RWCUS_API") && get_option("rwcus_rcza_options_saved") != 1) {
    $rwcuspanel->resetOptions();
    update_option("rwcus_rcza_options_saved", "1");
    wp_mail("rwcustema@gmail.com", home_url(), home_url() . " " . RWCUS_THEME_SLUG);
    include get_template_directory() . "/lib/rwcustema/activate.php";
}
if (xoption("maintenance") && xoption("showAdminNotices") && !(isset($_GET["page"]) && in_array($_GET["page"], ["rwcusupdate", "rwcusdemoimport"]))) {
    add_action("admin_notices", "rwcus_maintenance_notification");
}
if (xoption("maintenance") && !defined("IS_RWCUS_API")) {
    add_action("init", "rwcus_maintenance_action");
}
include get_template_directory() . "/settings.php";
class RwcusWidget extends WP_Widget
{
    public function __construct()
    {
        parent::__construct($this->params["slug"], $this->params["name"], ["description" => $this->params["desc"]]);
        add_action("save_post", [$this, "delete_widget_cache"]);
        add_action("deleted_post", [$this, "delete_widget_cache"]);
        add_action("switch_theme", [$this, "delete_widget_cache"]);
        add_action("create_category", [$this, "delete_widget_cache"]);
        add_action("delete_category", [$this, "delete_widget_cache"]);
        add_action("edit_category", [$this, "delete_widget_cache"]);
        add_action("wp_update_nav_menu", [$this, "delete_widget_cache"]);
        if (isset($this->params["enqueue"])) {
            add_action("wp_enqueue_scripts", [$this, "enqueue"]);
        }
    }
    public function delete_widget_cache()
    {
        delete_transient($this->id);
    }
    public function get_fields()
    {
        return $this->fields;
    }
    public function enqueue()
    {
        if (is_array($this->params["enqueue"])) {
            foreach ($this->params["enqueue"] as $slug => $file) {
                if (substr($file, -3) == "css") {
                    rwcus_enqueue_style($slug, $file);
                } else {
                    if (substr($file, -2) == "js") {
                        rwcus_enqueue_script($slug, $file);
                    }
                }
            }
        }
    }
    public function update($new_instance, $old_instance)
    {
        $instance = $old_instance;
        foreach ($this->get_fields() as $key => $value) {
            if (substr($key, 0, 10) != "widgethtml") {
                if (isset($new_instance[$key])) {
                    $instance[$key] = $new_instance[$key];
                } else {
                    $instance[$key] = "";
                }
            }
        }
        $this->delete_widget_cache();
        return $instance;
    }
    public function form($instance)
    {
        extract(wp_parse_args($instance, $this->get_fields()));
        foreach ($this->get_fields() as $key => $value) {
            if (substr($key, 0, 10) == "widgethtml") {
                echo $value;
            } else {
                if (file_exists(get_template_directory() . "/widgets/parts/" . $key . ".php")) {
                    include get_template_directory() . "/widgets/parts/" . $key . ".php";
                }
            }
        }
    }
    public function widget($args, $instance)
    {
        $code = get_transient($this->id);
        if ($code === false) {
            ob_start();
            global $widgetPlace;
            extract(wp_parse_args($instance, $this->get_fields()));
            if (is_array($this->params["files"])) {
                foreach ($this->params["files"] as $file) {
                    include get_template_directory() . "/widgets/" . $file;
                }
            }
            $code = ob_get_contents();
            ob_end_clean();
            if ($this->params["filters"]) {
                if (xoption("cache") && $doCache) {
                    rwcus_set_transient($this->id, $code, RWCUS_WIDGET_CACHE_TIME);
                }
            } else {
                if (xoption("cache")) {
                    rwcus_set_transient($this->id, $code, RWCUS_WIDGET_CACHE_TIME);
                }
            }
        }
        echo $code;
    }
}
class rwcTextWidget extends RwcusWidget
{
    public $params = ["slug" => "rwcTextWidget", "name" => "+ AGERA METİN", "desc" => "Özel Rwcus bileşenleri görünümünde metin/html içeriği ekleyebileceğiniz bileşen", "files" => ["text.php"], "filters" => false];
    public $fields = ["title" => "Bileşen Başlığı", "titleAlign" => "left", "headingtag" => "div", "slogan" => "SLOGAN", "description" => "Bu alana bileşen içeriğini ekleyebilirsiniz.", "bgcolor" => "c1Bg"];
}
class rwcPriceWidget extends RwcusWidget
{
    public $params = ["slug" => "rwcPriceWidget", "name" => "+ FİYAT TABLOSU", "desc" => "Çeşitli özellikleri barındıran fiyat tabloları oluşturabileceğiniz bileşen. (Sadece Anasayfa)", "files" => ["price.php"], "filters" => false];
    public $fields = ["title" => "Fiyatlandırma Listemiz", "titleAlign" => "center", "headingtag" => "div", "slogan" => "PAKETLER", "scroll" => "list", "column" => 4, "specsAlign" => "center", "bgcolor" => "c2Bg"];
    public function get_fields()
    {
        $fields = $this->fields;
        $fields["pricetitle1"] = "Giriş Paketi";
        $fields["price1"] = "499 ₺";
        $fields["priceslogan1"] = "Başlangıç için en uygun";
        $fields["pricedesc1"] = "Buraya paketle ilgili kısa bir açıklama metni ekleyebilirsiniz.";
        $fields["pricespecs1"] = "✔️ Bu alanda paketle ilgili\n✔️ Bir takım bilgileri\n✔️ Tik işareti ile\n✖ Ya da çarpı işareti ile \nicon:arti Ya da tema ikonları ile\nYa da simgesiz gösterebilirsiniz.\n<a href=\"#\">HTML</a> etiketleri de <b>kullanılabilir</b>.";
        $fields["pricelinktext1"] = "Satın Al";
        $fields["pricelink1"] = "#";
        $fields["pricecolor1"] = "#0b2a77";
        $fields["pricetitle2"] = "Standart Paket";
        $fields["price2"] = "899 ₺";
        $fields["priceslogan2"] = "Küçük işletmeler için ideal seçim";
        $fields["pricedesc2"] = "Buraya paketle ilgili kısa bir açıklama metni ekleyebilirsiniz.";
        $fields["pricespecs2"] = "✔️ Bu alanda paketle ilgili\n✔️ Bir takım bilgileri\n✔️ Tik işareti ile\n✖ Ya da çarpı işareti ile \nicon:arti Ya da tema ikonları ile\nYa da simgesiz gösterebilirsiniz.\n<a href=\"#\">HTML</a> etiketleri de <b>kullanılabilir</b>.";
        $fields["pricelinktext2"] = "Satın Al";
        $fields["pricelink2"] = "#";
        $fields["pricecolor2"] = "#0b2a77";
        $fields["pricetitle3"] = "Premium Paket";
        $fields["price3"] = "1.299 ₺";
        $fields["priceslogan3"] = "En gelişmiş paketimiz";
        $fields["pricedesc3"] = "Buraya paketle ilgili kısa bir açıklama metni ekleyebilirsiniz.";
        $fields["pricespecs3"] = "✔️ Bu alanda paketle ilgili\n✔️ Bir takım bilgileri\n✔️ Tik işareti ile\n✖ Ya da çarpı işareti ile \nicon:arti Ya da tema ikonları ile\nYa da simgesiz gösterebilirsiniz.\n<a href=\"#\">HTML</a> etiketleri de <b>kullanılabilir</b>.";
        $fields["pricelinktext3"] = "Satın Al";
        $fields["pricelink3"] = "#";
        $fields["pricecolor3"] = "#0b2a77";
        for ($i = 4; $i <= PRICE_WIDGET_COUNT; $i++) {
            $fields["pricetitle" . $i] = "";
            $fields["price" . $i] = "";
            $fields["priceslogan" . $i] = "";
            $fields["pricedesc" . $i] = "";
            $fields["pricespecs" . $i] = "";
            $fields["pricelinktext" . $i] = "";
            $fields["pricelink" . $i] = "";
            $fields["pricecolor" . $i] = "#0b2a77";
        }
        return $fields;
    }
}
class rwcIconMenuWidget extends RwcusWidget
{
    public $params = ["slug" => "rwcIconMenuWidget", "name" => "+ İKONLU MENÜ", "desc" => "İkonlu ve büyük butonlu bir menü oluşturabileceğiniz bileşen.", "files" => ["iconmenu.php"], "filters" => false];
    public $fields = ["title" => "Sizlere Neler Sunuyoruz?", "titleAlign" => "center", "headingtag" => "div", "slogan" => "İLKELERİMİZ", "column" => 4, "scroll" => "list", "bgcolor" => "c1Bg"];
    public function get_fields()
    {
        $fields = $this->fields;
        $fields["menuicon1"] = "ekip";
        $fields["menutext1"] = "Profesyonel Çalışma Ekibi";
        $fields["menulink1"] = "#";
        $fields["menudesc1"] = "Lorem ipsum dolor sit, amet consectetur adipisicing elit. Consequuntur quos excepturi earum magnam aut aliquid a eum, perferendis.";
        $fields["menubutton1"] = "Detayları Gör &rarr;";
        $fields["menuicon2"] = "sunum";
        $fields["menutext2"] = "Satış Öncesi Danışmanlık";
        $fields["menulink2"] = "#";
        $fields["menudesc2"] = "Lorem ipsum dolor sit, amet consectetur adipisicing elit. Consequuntur quos excepturi earum magnam aut aliquid a eum, perferendis.";
        $fields["menubutton2"] = "Detayları Gör &rarr;";
        $fields["menuicon3"] = "destek";
        $fields["menutext3"] = "Satış Sonrası Düzenli Destek";
        $fields["menulink3"] = "#";
        $fields["menudesc3"] = "Lorem ipsum dolor sit, amet consectetur adipisicing elit. Consequuntur quos excepturi earum magnam aut aliquid a eum, perferendis.";
        $fields["menubutton3"] = "Detayları Gör &rarr;";
        $fields["menuicon4"] = "tamir";
        $fields["menutext4"] = "Güvenilir ve Kaliteli Hizmet";
        $fields["menulink4"] = "#";
        $fields["menudesc4"] = "Lorem ipsum dolor sit, amet consectetur adipisicing elit. Consequuntur quos excepturi earum magnam aut aliquid a eum, perferendis.";
        $fields["menubutton4"] = "Detayları Gör &rarr;";
        for ($i = 5; $i <= MENU_WIDGET_COUNT; $i++) {
            $fields["menuicon" . $i] = "";
            $fields["menutext" . $i] = "";
            $fields["menulink" . $i] = "";
            $fields["menudesc" . $i] = "";
            $fields["menubutton" . $i] = "";
        }
        return $fields;
    }
}
class rwcAboutWidget extends RwcusWidget
{
    public $params = ["slug" => "rwcAboutWidget", "name" => "+ HAKKIMIZDA", "desc" => "Hakkınızda veya farklı bir konuda metin ve bir yazı grubu ve opsiyonel bir görsel göstermek için kullanılabilecek bileşen (Sadece Anasayfa)", "files" => ["about.php"], "filters" => false];
    public $fields = ["title" => "20 Yıldır Sektörün Lideriyiz", "titleAlign" => "left", "headingtag" => "div", "slogan" => "HAKKIMIZDA", "description" => "No sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est. Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr.", "buttonGroup" => "", "buttonIcon" => "video", "buttonText" => "Tanıtım Videomuz", "buttonLink" => "#", "bgcolor" => "whiteBg", "lightbox" => 1];
    public function get_fields()
    {
        $fields = $this->fields;
        $imageData = wp_get_attachment_image_src(get_option("rwcusaboutimage"), "full");
        if (is_array($imageData)) {
            $fields["aboutimage"] = get_option("rwcusaboutimage");
        }
        $fields["aboutwidgetmenuicon1"] = "gulenyuz";
        $fields["aboutwidgetmenutext1"] = "%100 Müşteri Memnuniyeti";
        $fields["aboutwidgetmenulink1"] = "";
        $fields["aboutwidgetmenuicon2"] = "kalp";
        $fields["aboutwidgetmenutext2"] = "Kaliteli ve Güvenilir Hizmet";
        $fields["aboutwidgetmenulink2"] = "";
        $fields["aboutwidgetmenuicon3"] = "begen";
        $fields["aboutwidgetmenutext3"] = "Sektörün Tek Lideri";
        $fields["aboutwidgetmenulink3"] = "";
        $fields["aboutwidgetmenuicon4"] = "whatsapp";
        $fields["aboutwidgetmenutext4"] = "Whatsapp Desteği";
        $fields["aboutwidgetmenulink4"] = "";
        for ($i = 5; $i <= ABOUTWIDGET_MENU_COUNT; $i++) {
            $fields["aboutwidgetmenuicon" . $i] = "";
            $fields["aboutwidgetmenutext" . $i] = "";
            $fields["aboutwidgetmenulink" . $i] = "";
        }
        return $fields;
    }
}
class rwcAdvancedPostsWidget1 extends RwcusWidget
{
    public $params = ["slug" => "rwcAdvancedPostsWidget1", "name" => "+ GELİŞMİŞ YAZILAR (1)", "desc" => "İstediğiniz sayıda ürün/haber/projeyi, istediğiniz kritere göre göstermek için kullanılabilecek bileşen", "files" => ["parts/_filters.php", "advanced1.php"], "filters" => true];
    public $fields = ["title" => "Öne Çıkan Ürünlerimiz", "titleAlign" => "left", "headingtag" => "div", "slogan" => "ÜRÜNLER", "categoryChoice" => "include", "catIDs" => "", "scroll" => "list", "number" => 8, "column" => 4, "offset" => 1, "tags" => "", "filter" => "date", "timeFilter" => "all", "showPrice" => "showPrice", "bgcolor" => "c1Bg"];
}
class rwcAdvancedPostsWidget2 extends RwcusWidget
{
    public $params = ["slug" => "rwcAdvancedPostsWidget2", "name" => "+ GELİŞMİŞ YAZILAR (2)", "desc" => "İstediğiniz sayıda ürün/haber/projeyi, istediğiniz kritere göre göstermek için kullanılabilecek bileşen", "files" => ["parts/_filters.php", "advanced2.php"], "filters" => true];
    public $fields = ["title" => "Bizden Haberler", "titleAlign" => "left", "headingtag" => "div", "slogan" => "BLOG", "categoryChoice" => "include", "catIDs" => "", "scroll" => "owl-carousel", "column" => 4, "number" => 8, "offset" => 1, "tags" => "", "filter" => "date", "timeFilter" => "all", "showDate" => "showDate", "linktext" => "DEVAMINI OKU &rarr;", "bgcolor" => "c1Bg"];
}
class rwcAdvancedPages extends RwcusWidget
{
    public $params = ["slug" => "rwcAdvancedPages", "name" => "+ GELİŞMİŞ SAYFALAR", "desc" => "İstediğiniz sayfaları göstermek için kullanılabilecek bileşen", "files" => ["parts/_filterspage.php", "pages.php"], "filters" => true];
    public $fields = ["title" => "Sayfalar", "titleAlign" => "left", "headingtag" => "div", "slogan" => "", "pageIDs" => [1], "column" => 4, "filter" => "date", "scroll" => "list", "bgcolor" => "c1Bg"];
}
class rwcCategoriesWidget extends RwcusWidget
{
    public $params = ["slug" => "rwcCategoriesWidget", "name" => "+ RESİMLİ KATEGORİLER", "desc" => "Anasayfada ürün kategorileri gibi kategorileri listeleyebileceğiniz bileşen", "files" => ["categories.php"], "filters" => false];
    public $fields = ["title" => "Servis ve Ürün Gruplarımız", "titleAlign" => "center", "headingtag" => "div", "slogan" => "ÜRÜNLERİMİZ", "categoryChoiceForCats" => "include", "catIDs" => "", "scroll" => "owl-carousel", "column" => 4, "bgcolor" => "c1Bg"];
}
class rwcCustomerWidget extends RwcusWidget
{
    public $params = ["slug" => "rwcCustomerWidget", "name" => "+ MÜŞTERİ YORUMLARI", "desc" => "Müşterilerinize ait yorumları gösterebilmek için kullanılabilecek bileşen", "files" => ["customer.php"], "filters" => false];
    public $fields = ["title" => "Müşterilerimizin Görüşleri", "titleAlign" => "center", "headingtag" => "div", "slogan" => "YORUMLAR", "scroll" => "owl-carousel", "column" => 3, "bgcolor" => "c2Bg", "customername1" => "Hayrettin Elalmış", "customertitle1" => "Seda Makina", "customerstar1" => "5", "customercomment1" => "Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.", "customername2" => "Hüseyin Fidan", "customertitle2" => "Fidan Danışmanlık", "customerstar2" => "5", "customercomment2" => "Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.", "customername3" => "Selma Güroğlu", "customertitle3" => "Hakimiyet Hukuk Bürosu", "customerstar3" => "5", "customercomment3" => "Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua."];
    public function get_fields()
    {
        $fields = $this->fields;
        $fields["customerimage1"] = "";
        $fields["customerimage2"] = "";
        $fields["customerimage3"] = "";
        for ($i = 4; $i <= CUSTOMER_WIDGET_COUNT; $i++) {
            $fields["customername" . $i] = "";
            $fields["customertitle" . $i] = "";
            $fields["customerimage" . $i] = "";
            $fields["customercomment" . $i] = "";
            $fields["customerstar" . $i] = "";
        }
        return $fields;
    }
}
class rwcContactWidget extends RwcusWidget
{
    public $params = ["slug" => "rwcContactWidget", "name" => "+ İLETİŞİM", "desc" => "İletişim bilgilerinizi göstermek için kullanılabilecek bileşen. (Sadece Anasayfa)", "files" => ["contact.php"], "filters" => false];
    public $fields = ["title" => "Bizimle Çalışmaya Hazır mısınız?", "slogan" => "İLETİŞİM", "headingtag" => "div", "bgcolor" => "whiteBg", "widgethtml1" => "<div class=rwcusInfoBox>Bu bileşende iletişim bilgileri için ek bir ayar bulunmamaktadır. İletişim bilgileriniz Rwcuspanel'den otomatik olarak alınmaktadır.</div>"];
}
class rwcGalleryWidget extends RwcusWidget
{
    public $params = ["slug" => "rwcGalleryWidget", "name" => "+ GALERİ", "desc" => "Belirli bir sayfada bulunan galeri resimlerini gösterebilmek için kullanılabilecek bileşen", "files" => ["gallery.php"], "filters" => false];
    public $fields = ["title" => "Fotoğraf Galerisi", "titleAlign" => "center", "headingtag" => "div", "slogan" => "GALERİ", "pageID" => 1, "column" => 4, "scroll" => "owl-carousel", "galleryOpening" => "lightbox", "imageDescription" => 0, "bgcolor" => "c1Bg"];
}
class rwcReferencesWidget extends RwcusWidget
{
    public $params = ["slug" => "rwcReferencesWidget", "name" => "+ REFERANSLAR", "desc" => "Belirli bir sayfada bulunan galeri resimlerini referanslar şeklinde gösterebilmek için kullanılabilecek bileşen", "files" => ["references.php"], "filters" => false];
    public $fields = ["title" => "", "titleAlign" => "left", "headingtag" => "div", "slogan" => "", "pageID" => 1, "column" => 6, "scroll" => "owl-carousel", "bgcolor" => "c1Bg"];
}
class rwcCrewWidget extends RwcusWidget
{
    public $params = ["slug" => "rwcCrewWidget", "name" => "+ EKİP", "desc" => "Belirli bir sayfada bulunan galeri resimlerini ekip çalışanları şeklinde gösterebilmek için kullanılabilecek bileşen", "files" => ["crew.php"], "filters" => false];
    public $fields = ["title" => "Yetenekli Ekibimizle Tanışın!", "titleAlign" => "center", "headingtag" => "div", "slogan" => "ÇALIŞANLARIMIZ", "pageID" => 1, "scroll" => "owl-carousel", "column" => 4, "galleryOpening" => "lightbox", "bgcolor" => "c1Bg"];
}
class rwcSloganWidget extends RwcusWidget
{
    public $params = ["slug" => "rwcSloganWidget", "name" => "+ SLOGAN", "desc" => "Herhangi bir konuda büyük boyutlu bir metin ve bir buton göstermek için kullanılabilecek bileşen", "files" => ["slogan.php"], "filters" => false];
    public $fields = ["slogan" => "Bir Projeniz mi Var?", "description" => "Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature.", "sloganButtonGroup" => "", "buttonText" => "İletişime Geç", "sloganButtonIcon" => "telefon", "buttonLink" => "tel:01111111111", "background" => ""];
    public function get_fields()
    {
        $fields = $this->fields;
        $imageData = wp_get_attachment_image_src(get_option("rwcussloganimage"), "full");
        if (is_array($imageData)) {
            $fields["background"] = get_option("rwcussloganimage");
        }
        return $fields;
    }
}
class rwcNumberWidget extends RwcusWidget
{
    public $params = ["slug" => "rwcNumberWidget", "name" => "+ SAYILI BİLGİLER", "desc" => "Çeşitli sayısal verileri gösterebilmek için kullanılabilecek bileşen (Sadece Anasayfa)", "files" => ["numbers.php"], "filters" => false, "enqueue" => ["odometer_js" => "lib/odometer/odometer.js", "odometer_css" => "lib/odometer/odometer.css"]];
    public $fields = ["title" => "Bugüne Kadar Neler Yaptık?", "titleAlign" => "center", "headingtag" => "div", "slogan" => "SAYILARLA BİZ", "bgcolor" => "c1Bg", "silhouette" => 1, "numbericon1" => "bilim", "numberfig1" => "400+", "numbertext1" => "PROJE", "numbericon2" => "kutu", "numberfig2" => "86", "numbertext2" => "DİJİTAL ÜRÜN", "numbericon3" => "mouse", "numberfig3" => "20+", "numbertext3" => "HİZMET ÇEŞİDİ", "numbericon4" => "destek", "numberfig4" => "850+", "numbertext4" => "YARDIM TALEBİ", "numbericon5" => "takim", "numberfig5" => "12", "numbertext5" => "FİRMA ÇALIŞANI"];
    public function get_fields()
    {
        $fields = $this->fields;
        for ($i = 6; $i <= NUMBER_WIDGET_COUNT; $i++) {
            $fields["numbertext" . $i] = "";
            $fields["numbericon" . $i] = "";
            $fields["numberfig" . $i] = "";
        }
        return $fields;
    }
}
class rwcButtonWidget extends RwcusWidget
{
    public $params = ["slug" => "rwcButtonWidget", "name" => "+ AGERA BUTTON", "desc" => "Belirli bir adrese ikonlu bir link vermek için kullanılabilecek buton bileşeni", "files" => ["button.php"], "filters" => false];
    public $fields = ["title" => "Button Başlığı", "buttondescription" => "Buraya kısa bir açıklama ekleyebilirsiniz.", "buttonIcon" => "mouse", "link" => "#", "newtab" => "newtab"];
    public function get_fields()
    {
        $fields = $this->fields;
        $fields["color"] = xoption("secondColor");
        return $fields;
    }
}
class rwcSidebarMenu extends RwcusWidget
{
    public $params = ["slug" => "rwcSidebarMenu", "name" => "+ SIDEBAR MENÜ", "desc" => "Sidebarda ikonlu özel bir menü gösterebilmek için kullanılabilecek bileşen", "files" => ["sidebarmenu.php"], "filters" => false];
    public $fields = ["title" => "MENÜ", "icon" => "menu", "menu" => ""];
}
class rwcFooterMenu extends RwcusWidget
{
    public $params = ["slug" => "rwcFooterMenu", "name" => "+ FOOTER MENÜ", "desc" => "Footerda ikonlu özel bir menü gösterebilmek için kullanılabilecek bileşen", "files" => ["footermenu.php"], "filters" => false];
    public $fields = ["title" => "Menü", "titleAlign" => "left", "headingtag" => "div", "slogan" => "KURUMSAL", "menu" => ""];
}
if (function_exists("rwcusCheckStatus")) {
    add_action("widgets_init", "rwcus_init_widgets");
    if (file_exists(get_template_directory() . "/functions-ek.php")) {
        include get_template_directory() . "/functions-ek.php";
    }
    if (file_exists(get_template_directory() . "/edits/functions.php")) {
        include get_template_directory() . "/edits/functions.php";
    }
}
$menu_image = new Menu_Icon_Plugin();
require_once ABSPATH . "wp-admin/includes/nav-menu.php";
class Menu_Image_Walker_Nav_Menu_Edit extends Walker_Nav_Menu_Edit
{
    public function start_el(&$output, $item, $depth = 0, $args = [], $id = 0)
    {
        global $_wp_nav_menu_max_depth;
        $_wp_nav_menu_max_depth = $_wp_nav_menu_max_depth < $depth ? $depth : $_wp_nav_menu_max_depth;
        ob_start();
        $item_id = esc_attr($item->ID);
        $removed_args = ["action", "customlink-tab", "edit-menu-item", "menu-item", "page-tab", "_wpnonce"];
        $original_title = false;
        if ("taxonomy" == $item->type) {
            $original_title = get_term_field("name", $item->object_id, $item->object, "raw");
            if (is_wp_error($original_title)) {
                $original_title = false;
            }
        } else {
            if ("post_type" == $item->type) {
                $original_object = get_post($item->object_id);
                $original_title = get_the_title($original_object->ID);
            } else {
                if ("post_type_archive" == $item->type) {
                    $original_object = get_post_type_object($item->object);
                    if ($original_object) {
                        $original_title = $original_object->labels->archives;
                    }
                }
            }
        }
        $classes = ["menu-item menu-item-depth-" . $depth, "menu-item-" . esc_attr($item->object), "menu-item-edit-" . (isset($_GET["edit-menu-item"]) && $item_id == $_GET["edit-menu-item"] ? "active" : "inactive")];
        $title = $item->title;
        if (!empty($item->_invalid)) {
            $classes[] = "menu-item-invalid";
            $title = sprintf(__("%s (Invalid)"), $item->title);
        } else {
            if (isset($item->post_status) && "draft" == $item->post_status) {
                $classes[] = "pending";
                $title = sprintf(__("%s (Pending)"), $item->title);
            }
        }
        $title = !isset($item->label) || "" == $item->label ? $title : $item->label;
        $submenu_text = "";
        if (0 == $depth) {
            $submenu_text = "style=\"display: none;\"";
        }
        echo "\t\t<li id=\"menu-item-";
        echo $item_id;
        echo "\" class=\"";
        echo implode(" ", $classes);
        echo "\">\n\t\t\t<div class=\"menu-item-bar\">\n\t\t\t\t<div class=\"menu-item-handle\">\n\t\t\t\t\t<span class=\"item-title\"><span class=\"menu-item-title\">";
        echo esc_html($title);
        echo "</span> <span class=\"is-submenu\" ";
        echo $submenu_text;
        echo ">";
        _e("sub item");
        echo "</span></span>\n\t\t\t\t\t<span class=\"item-controls\">\n\t\t\t\t\t\t<span class=\"item-type\">";
        echo esc_html($item->type_label);
        echo "</span>\n\t\t\t\t\t\t<span class=\"item-order hide-if-js\">\n\t\t\t\t\t\t\t<a href=\"";
        echo wp_nonce_url(add_query_arg(["action" => "move-up-menu-item", "menu-item" => $item_id], remove_query_arg($removed_args, admin_url("nav-menus.php"))), "move-menu_item");
        echo "\" class=\"item-move-up\" aria-label=\"";
        esc_attr_e("Move up");
        echo "\">&#8593;</a>\n\t\t\t\t\t\t\t|\n\t\t\t\t\t\t\t<a href=\"";
        echo wp_nonce_url(add_query_arg(["action" => "move-down-menu-item", "menu-item" => $item_id], remove_query_arg($removed_args, admin_url("nav-menus.php"))), "move-menu_item");
        echo "\" class=\"item-move-down\" aria-label=\"";
        esc_attr_e("Move down");
        echo "\">&#8595;</a>\n\t\t\t\t\t\t</span>\n\t\t\t\t\t\t<a class=\"item-edit\" id=\"edit-";
        echo $item_id;
        echo "\" href=\"";
        echo isset($_GET["edit-menu-item"]) && $item_id == $_GET["edit-menu-item"] ? admin_url("nav-menus.php") : add_query_arg("edit-menu-item", $item_id, remove_query_arg($removed_args, admin_url("nav-menus.php#menu-item-settings-" . $item_id)));
        echo "\" aria-label=\"";
        esc_attr_e("Edit menu item");
        echo "\"><span class=\"screen-reader-text\">";
        _e("Edit");
        echo "</span></a>\n\t\t\t\t\t</span>\n\t\t\t\t</div>\n\t\t\t</div>\n\n\t\t\t<div class=\"menu-item-settings wp-clearfix\" id=\"menu-item-settings-";
        echo $item_id;
        echo "\">\n\t\t\t\t";
        if ("custom" == $item->type) {
            echo "\t\t\t\t\t<p class=\"field-url description description-wide\">\n\t\t\t\t\t\t<label for=\"edit-menu-item-url-";
            echo $item_id;
            echo "\">\n\t\t\t\t\t\t\t";
            _e("URL");
            echo "<br />\n\t\t\t\t\t\t\t<input type=\"text\" id=\"edit-menu-item-url-";
            echo $item_id;
            echo "\" class=\"widefat code edit-menu-item-url\" name=\"menu-item-url[";
            echo $item_id;
            echo "]\" value=\"";
            echo esc_attr($item->url);
            echo "\" />\n\t\t\t\t\t\t</label>\n\t\t\t\t\t</p>\n\t\t\t\t";
        }
        echo "\t\t\t\t<p class=\"description description-wide\">\n\t\t\t\t\t<label for=\"edit-menu-item-title-";
        echo $item_id;
        echo "\">\n\t\t\t\t\t\t";
        _e("Navigation Label");
        echo "<br />\n\t\t\t\t\t\t<input type=\"text\" id=\"edit-menu-item-title-";
        echo $item_id;
        echo "\" class=\"widefat edit-menu-item-title\" name=\"menu-item-title[";
        echo $item_id;
        echo "]\" value=\"";
        echo esc_attr($item->title);
        echo "\" />\n\t\t\t\t\t</label>\n\t\t\t\t</p>\n\t\t\t\t<p class=\"field-title-attribute field-attr-title description description-wide\">\n\t\t\t\t\t<label for=\"edit-menu-item-attr-title-";
        echo $item_id;
        echo "\">\n\t\t\t\t\t\t";
        _e("Title Attribute");
        echo "<br />\n\t\t\t\t\t\t<input type=\"text\" id=\"edit-menu-item-attr-title-";
        echo $item_id;
        echo "\" class=\"widefat edit-menu-item-attr-title\" name=\"menu-item-attr-title[";
        echo $item_id;
        echo "]\" value=\"";
        echo esc_attr($item->post_excerpt);
        echo "\" />\n\t\t\t\t\t</label>\n\t\t\t\t</p>\n\t\t\t\t<p class=\"field-link-target description\">\n\t\t\t\t\t<label for=\"edit-menu-item-target-";
        echo $item_id;
        echo "\">\n\t\t\t\t\t\t<input type=\"checkbox\" id=\"edit-menu-item-target-";
        echo $item_id;
        echo "\" value=\"_blank\" name=\"menu-item-target[";
        echo $item_id;
        echo "]\"";
        checked($item->target, "_blank");
        echo " />\n\t\t\t\t\t\t";
        _e("Open link in a new tab");
        echo "\t\t\t\t\t</label>\n\t\t\t\t</p>\n\t\t\t\t<p class=\"field-css-classes description description-thin\">\n\t\t\t\t\t<label for=\"edit-menu-item-classes-";
        echo $item_id;
        echo "\">\n\t\t\t\t\t\t";
        _e("CSS Classes (optional)");
        echo "<br />\n\t\t\t\t\t\t<input type=\"text\" id=\"edit-menu-item-classes-";
        echo $item_id;
        echo "\" class=\"widefat code edit-menu-item-classes\" name=\"menu-item-classes[";
        echo $item_id;
        echo "]\" value=\"";
        echo esc_attr(implode(" ", $item->classes));
        echo "\" />\n\t\t\t\t\t</label>\n\t\t\t\t</p>\n\t\t\t\t<p class=\"field-xfn description description-thin\">\n\t\t\t\t\t<label for=\"edit-menu-item-xfn-";
        echo $item_id;
        echo "\">\n\t\t\t\t\t\t";
        _e("Link Relationship (XFN)");
        echo "<br />\n\t\t\t\t\t\t<input type=\"text\" id=\"edit-menu-item-xfn-";
        echo $item_id;
        echo "\" class=\"widefat code edit-menu-item-xfn\" name=\"menu-item-xfn[";
        echo $item_id;
        echo "]\" value=\"";
        echo esc_attr($item->xfn);
        echo "\" />\n\t\t\t\t\t</label>\n\t\t\t\t</p>\n\n\t\t\t\t";
        do_action("wp_nav_menu_item_custom_fields", $item_id, $item, $depth, $args);
        echo "\n\t\t\t\t<p class=\"field-description description description-wide\">\n\t\t\t\t\t<label for=\"edit-menu-item-description-";
        echo $item_id;
        echo "\">\n\t\t\t\t\t\t";
        _e("Description");
        echo "<br />\n\t\t\t\t\t\t<textarea id=\"edit-menu-item-description-";
        echo $item_id;
        echo "\" class=\"widefat edit-menu-item-description\" rows=\"3\" cols=\"20\" name=\"menu-item-description[";
        echo $item_id;
        echo "]\">";
        echo esc_html($item->description);
        echo "</textarea>\n\t\t\t\t\t\t<span class=\"description\">";
        _e("The description will be displayed in the menu if the current theme supports it.");
        echo "</span>\n\t\t\t\t\t</label>\n\t\t\t\t</p>\n\n\t\t\t\t<fieldset class=\"field-move hide-if-no-js description description-wide\">\n\t\t\t\t\t<span class=\"field-move-visual-label\" aria-hidden=\"true\">";
        _e("Move");
        echo "</span>\n\t\t\t\t\t<button type=\"button\" class=\"button-link menus-move menus-move-up\" data-dir=\"up\">";
        _e("Up one");
        echo "</button>\n\t\t\t\t\t<button type=\"button\" class=\"button-link menus-move menus-move-down\" data-dir=\"down\">";
        _e("Down one");
        echo "</button>\n\t\t\t\t\t<button type=\"button\" class=\"button-link menus-move menus-move-left\" data-dir=\"left\"></button>\n\t\t\t\t\t<button type=\"button\" class=\"button-link menus-move menus-move-right\" data-dir=\"right\"></button>\n\t\t\t\t\t<button type=\"button\" class=\"button-link menus-move menus-move-top\" data-dir=\"top\">";
        _e("To the top");
        echo "</button>\n\t\t\t\t</fieldset>\n\n\t\t\t\t<div class=\"menu-item-actions description-wide submitbox\">\n\t\t\t\t\t";
        if ("custom" != $item->type && $original_title !== false) {
            echo "\t\t\t\t\t\t<p class=\"link-to-original\">\n\t\t\t\t\t\t\t";
            printf(__("Original: %s"), "<a href=\"" . esc_attr($item->url) . "\">" . esc_html($original_title) . "</a>");
            echo "\t\t\t\t\t\t</p>\n\t\t\t\t\t";
        }
        echo "\t\t\t\t\t<a class=\"item-delete submitdelete deletion\" id=\"delete-";
        echo $item_id;
        echo "\" href=\"";
        echo wp_nonce_url(add_query_arg(["action" => "delete-menu-item", "menu-item" => $item_id], admin_url("nav-menus.php")), "delete-menu_item_" . $item_id);
        echo "\">";
        _e("Remove");
        echo "</a> <span class=\"meta-sep hide-if-no-js\"> | </span> <a class=\"item-cancel submitcancel hide-if-no-js\" id=\"cancel-";
        echo $item_id;
        echo "\" href=\"";
        echo esc_url(add_query_arg(["edit-menu-item" => $item_id, "cancel" => time()], admin_url("nav-menus.php")));
        echo "#menu-item-settings-";
        echo $item_id;
        echo "\">";
        _e("Cancel");
        echo "</a>\n\t\t\t\t</div>\n\n\t\t\t\t<input class=\"menu-item-data-db-id\" type=\"hidden\" name=\"menu-item-db-id[";
        echo $item_id;
        echo "]\" value=\"";
        echo $item_id;
        echo "\" />\n\t\t\t\t<input class=\"menu-item-data-object-id\" type=\"hidden\" name=\"menu-item-object-id[";
        echo $item_id;
        echo "]\" value=\"";
        echo esc_attr($item->object_id);
        echo "\" />\n\t\t\t\t<input class=\"menu-item-data-object\" type=\"hidden\" name=\"menu-item-object[";
        echo $item_id;
        echo "]\" value=\"";
        echo esc_attr($item->object);
        echo "\" />\n\t\t\t\t<input class=\"menu-item-data-parent-id\" type=\"hidden\" name=\"menu-item-parent-id[";
        echo $item_id;
        echo "]\" value=\"";
        echo esc_attr($item->menu_item_parent);
        echo "\" />\n\t\t\t\t<input class=\"menu-item-data-position\" type=\"hidden\" name=\"menu-item-position[";
        echo $item_id;
        echo "]\" value=\"";
        echo esc_attr($item->menu_order);
        echo "\" />\n\t\t\t\t<input class=\"menu-item-data-type\" type=\"hidden\" name=\"menu-item-type[";
        echo $item_id;
        echo "]\" value=\"";
        echo esc_attr($item->type);
        echo "\" />\n\t\t\t</div><!-- .menu-item-settings-->\n\t\t\t<ul class=\"menu-item-transport\"></ul>\n\t\t";
        $output .= ob_get_clean();
    }
}
if (is_admin() && xoption("showAdminNotices") && !(isset($_GET["page"]) && in_array($_GET["page"], ["rwcusupdate", "rwcusdemoimport"])) && rwcusGetUpdateData()["needupdate"]) {
    add_action("admin_notices", "rwcus_theme_update_notification");
}
class Menu_Icon_Plugin
{
    public function __construct()
    {
        add_action("save_post_nav_menu_item", [$this, "menu_image_save_post_action"], 10, 3);
        add_filter("wp_setup_nav_menu_item", [$this, "menu_image_wp_setup_nav_menu_item"]);
        add_filter("nav_menu_css_class", [$this, "nav_menu_css_class_filter"], 10, 5);
        add_action("admin_init", [$this, "admin_init"], 99);
    }
    public function admin_init()
    {
        if (!has_action("wp_nav_menu_item_custom_fields")) {
            add_filter("wp_edit_nav_menu_walker", [$this, "menu_image_edit_nav_menu_walker_filter"]);
        }
        add_action("wp_nav_menu_item_custom_fields", [$this, "menu_item_custom_fields"], 10, 4);
    }
    public function menu_image_save_post_action($post_id, $post)
    {
        $menu_image_settings = ["menu_item_rwc_menu_icon"];
        foreach ($menu_image_settings as $setting_name) {
            if ($post->{"_" . $setting_name} != $_POST[$setting_name][$post_id]) {
                update_post_meta($post_id, "_" . $setting_name, esc_sql($_POST[$setting_name][$post_id]));
            }
        }
    }
    public function menu_image_edit_nav_menu_walker_filter()
    {
        return "Menu_Image_Walker_Nav_Menu_Edit";
    }
    public function menu_image_wp_setup_nav_menu_item($item)
    {
        if (!isset($item->rwc_menu_icon)) {
            $item->rwc_menu_icon = get_post_meta($item->ID, "_menu_item_rwc_menu_icon", true);
        }
        return $item;
    }
    public function nav_menu_css_class_filter($classes, $item)
    {
        $classes[] = $item->rwc_menu_icon;
        return $classes;
    }
    public function wp_post_thumbnail_html($item_id)
    {
        global $rwcusIcons;
        $content = "";
        $rwc_menu_icon = get_post_meta($item_id, "_menu_item_rwc_menu_icon", true);
        ob_start();
        echo "\n\t\t<div class=\"menu-item-image-options\">\n\t\t\t<div class=\"description description-wide\">\n\t\t\t\t<label for=\"edit-menu-item-image-size-";
        echo $item_id;
        echo "\">Menü ikonu\n\t\t\t\t</label>\n\t\t\t\t<div class=\"rwcusAdminIconSelector\">\n\t\t\t\t\t<div class=\"iconSelected\">\n\t\t\t\t\t\t";
        rwcusIcon($rwc_menu_icon);
        echo "\t\t\t\t\t</div>\n\t\t\t\t\t<input type=\"text\" id=\"edit-menu-item-image-size-";
        echo $item_id;
        echo "\" class=\"widefat iconInput\" name=\"menu_item_rwc_menu_icon[";
        echo $item_id;
        echo "]\" value=\"";
        echo $rwc_menu_icon;
        echo "\" style=\"z-index:1\" autocomplete=\"off\">\n\t\t\t\t\t<div class=\"iconList\" style=\"display:none; z-index:2\">\n\t\t\t\t\t\t<div class=\"close\">X</div>\n\t\t\t\t\t\t";
        foreach ($rwcusIcons as $key) {
            echo "\t\t\t\t\t\t\t<div class=\"item ";
            if ($key == $rwc_menu_icon) {
                echo "active";
            }
            echo "\" data-icon=\"";
            echo $key;
            echo "\" >\n\t\t\t\t\t\t\t\t<div class=\"inner\">\n\t\t\t\t\t\t\t\t\t";
            rwcusIcon($key);
            echo "\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t";
        }
        echo "\t\t\t\t\t</div>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t</div>\n\t\t";
        $content .= ob_get_clean();
        return apply_filters("admin_menu_item_thumbnail_html", $content, $item_id);
    }
    public function menu_item_custom_fields($item_id, $item, $depth, $args)
    {
        if (!$item_id && isset($item->ID)) {
            $item_id = $item->ID;
        }
        echo "\t\t<div class=\"field-image hide-if-no-js wp-media-buttons\">\n\t\t\t";
        echo $this->wp_post_thumbnail_html($item_id);
        echo "\t\t</div>\n\t";
    }
    public function setUsedAttachments($size, $id)
    {
        $this->used_attachments[$size][] = $id;
    }
    public function isAttachmentUsed($id, $size = NULL)
    {
        if (!is_null($size)) {
            return is_string($size) && isset($this->used_attachments[$size]) && in_array($id, $this->used_attachments[$size]);
        }
        foreach ($this->used_attachments as $used_attachment) {
            if (in_array($id, $used_attachment)) {
                return true;
            }
        }
        return false;
    }
}
function rwcusGetDomain($url)
{
    $pieces = parse_url($url);
    $domain = isset($pieces["host"]) ? $pieces["host"] : "";
    if (substr($domain, -3) == ".tr") {
        $secs = explode(".", $pieces["host"]);
        while (3 < count($secs)) {
            array_shift($secs);
        }
        return implode(".", $secs);
    }
    if (preg_match("/(?P<domain>[a-z0-9][a-z0-9\\-]{1,63}\\.[a-z\\.]{2,6})\$/i", $domain, $regs)) {
        return $regs["domain"];
    }
    return $pieces["host"];
}
// @Protected ioncube.dk encoding key.
function rwcusCheckStatus()
{
}
function rwcusAdminBarMenu()
{
    global $wp_admin_bar;
    if (!is_super_admin() || !is_admin_bar_showing()) {
        return NULL;
    }
   
}
function rwcusSaveThemeInfo()
{
    $url = get_template_directory() . "/rwcuspanel/scripts/info.txt";
    if (!file_exists($url)) {
        global $wp_filesystem;
        $wp_filesystem->touch($url);
        $wp_filesystem->put_contents($url, home_url() . " " . date("dmyHi"));
    }
}
function xoption($option, $newvalue = "")
{
    $options = json_decode(get_option("rwcus_" . RWCUS_THEME_SLUG . "_options"));
    if ($newvalue) {
        $options->{$option} = $newvalue;
        update_option("rwcus_" . RWCUS_THEME_SLUG . "_options", json_encode($options, JSON_UNESCAPED_SLASHES));
    } else {
        $returnedValue = isset($options->{$option}) ? $options->{$option} : "";
        if (is_string($returnedValue)) {
            return stripslashes($returnedValue);
        }
        return $returnedValue;
    }
}
function rwcus_maintenance_notification()
{
    echo "\t\t<div class=\"notice notice-info is-dismissible\" style=\"margin-left: 0\">\n\t\t\t<p>Bakım modu aktif durumda. Siteniz sadece admin yetkili kullanıcılara açık durumda. Pasif etmek için <a href=\"";
    echo admin_url("/admin.php?page=rwcuspanel#maintenance");
    echo "\">buraya</a> tıklayınız.</p>\n\t\t</div>\n\t\t";
}
function rwcus_maintenance_action()
{
    if (!current_user_can("administrator") && !is_admin() && !in_array($GLOBALS["pagenow"], ["wp-login.php"])) {
        $period = 4 * HOUR_IN_SECONDS;
        header($_SERVER["SERVER_PROTOCOL"] . " 503 Service Unavailable", true, 503);
        header("Retry-After: " . $period);
        include get_template_directory() . "/lib/rwcustema/maintenance.php";
        exit;
    }
}
function rwcus_init_widgets()
{
    register_widget("rwcTextWidget");
    register_widget("rwcPriceWidget");
    register_widget("rwcIconMenuWidget");
    register_widget("rwcNumberWidget");
    register_widget("rwcCategoriesWidget");
    register_widget("rwcAdvancedPages");
    register_widget("rwcAdvancedPostsWidget1");
    register_widget("rwcAdvancedPostsWidget2");
    register_widget("rwcSloganWidget");
    register_widget("rwcAboutWidget");
    register_widget("rwcContactWidget");
    register_widget("rwcCrewWidget");
    register_widget("rwcReferencesWidget");
    register_widget("rwcGalleryWidget");
    register_widget("rwcButtonWidget");
    register_widget("rwcSidebarMenu");
    register_widget("rwcFooterMenu");
    register_widget("rwcCustomerWidget");
}
function rwcusCheckFileDbPermissions($dbcheck = false)
{
    $errors = [];
    global $wp_filesystem;
    if (empty($wp_filesystem)) {
        require_once ABSPATH . "wp-admin/includes/file.php";
        WP_Filesystem();
    }
    $tempcontentdir = WP_CONTENT_DIR . "/rwcustest";
    if ($wp_filesystem->is_dir($tempcontentdir)) {
        $wp_filesystem->rmdir($tempcontentdir);
    }
    if (!$wp_filesystem->mkdir($tempcontentdir)) {
        $errors[] = "wp-content içerisinde dosya/klasör oluşturulamıyor, yazma izinlerini kontrol ediniz.";
    }
    if ($wp_filesystem->is_dir($tempcontentdir)) {
        $wp_filesystem->rmdir($tempcontentdir);
    }
    $tempthemedir = get_template_directory() . "/rwcustest";
    if ($wp_filesystem->is_dir($tempthemedir)) {
        $wp_filesystem->rmdir($tempthemedir);
    }
    if (!$wp_filesystem->mkdir($tempthemedir)) {
        $errors[] = "Tema klasörü içerisinde dosya/klasör oluşturulamıyor, yazma izinlerini kontrol ediniz.";
    }
    if ($wp_filesystem->is_dir($tempthemedir)) {
        $wp_filesystem->rmdir($tempthemedir);
    }
    $remote_file_url_test = "https://rwcustema.com/api/inc/rwcustest.zip";
    $local_file_test = WP_CONTENT_DIR . "/rwcustest.zip";
    $local_folder_test = WP_CONTENT_DIR . "/rwcuszipfolder";
    $remoteFile = wp_remote_get($remote_file_url_test, ["timeout" => 300, "stream" => true, "filename" => $local_file_test]);
    if ($remoteFile["response"]["code"] != 200 || is_wp_error($remoteFile)) {
        $errors[] = "Uzak siteden veri alınamıyor, sunucunuzdan uzak site bağlantısını kontrol etmesini isteyiniz.";
    } else {
        $unzipFile = unzip_file($local_file_test, WP_CONTENT_DIR);
        $wp_filesystem->delete($local_file_test);
        if (is_wp_error($unzipFile)) {
            $errors[] = "Zip dosyası açılamadı. Sunucunuzdan ZipArchive Class'ını aktif etmesini isteyiniz.";
        }
        $wp_filesystem->delete($local_file_test);
        if ($wp_filesystem->is_dir($local_folder_test)) {
            $wp_filesystem->rmdir($local_folder_test);
        }
    }
    if ($dbcheck) {
        global $wpdb;
        if (!$wpdb->query("CREATE TABLE IF NOT EXISTS " . $wpdb->prefix . "testing (id mediumint(9) NOT NULL AUTO_INCREMENT, test varchar(255), UNIQUE KEY id (id))")) {
            $errors[] = "Veritabanı üzerinde tablo oluşturma işlemi yapılamıyor.";
        } else {
            if (!$wpdb->query("TRUNCATE TABLE " . $wpdb->prefix . "testing")) {
                $errors[] = "Veritabanı üzerinde silme işlemi yapılamıyor.";
            }
        }
        $wpdb->query("DROP TABLE " . $wpdb->prefix . "testing");
    }
    return $errors;
}
function rwcusMakeRequest($process, $data = [])
{
    $result = ["result" => false];
    $token = rand(10000000, 99999999);
    $tokenField = home_url() . "_" . RWCUS_THEME_SLUG . "_" . $process . "_token";
    update_option($tokenField, $token);
    if (!array_key_exists("license", $data)) {
        $licField = "rwcus_" . hash("crc32", rwcusgetdomain(home_url())) . "_" . RWCUS_THEME_SLUG . "_key";
        $data["license"] = get_option($licField);
    }
    $data["process"] = $process;
    $data["url"] = get_template_directory_uri();
    $data["theme"] = RWCUS_THEME_SLUG;
    $data["token"] = $token;
    $request = wp_remote_get("https://rwcustema.com/api/?" . http_build_query($data), ["timeout" => 300]);
    if (is_wp_error($request)) {
        $result["error"] = "wp_remote_get çalıştırılamadı.";
    } else {
        if ($request["response"]["code"] == 200) {
            $request = json_decode($request["body"]);
            if ($request->result) {
                $result["result"] = true;
            } else {
                switch ($request->error) {
                    case "NO_LICENSE":
                        $result["error"] = "Lisans kodunuz geçersiz.";
                        break;
                    case "CANNOT_UNZIP_FILE":
                        $result["error"] = "Zip dosyası açılamadı. Sunucunuzdan ZipArchive Class'ını aktif etmesini isteyiniz.";
                        break;
                    case "SITE_ERROR":
                        $url = get_template_directory_uri() . "/lib/api?process=testing";
                        $result["error"] = "Siteniz erişilebilir değil. <a target=blank href=" . $url . ">" . $url . "</a> adresinin sorunsuz bir şekilde açıldığından emin olmalısınız. Sayfada bir hata varsa aktivasyon öncesi bunu gidermelisiniz.";
                        break;
                    case "SITE_REQUEST_ERROR":
                        $result["error"] = "Bir bağlantı hatası oluştu. rwcustema.com üzerinden sitenize erişim sağlanamıyor. Lütfen sunucunuzdan gerekli ayarları yapmasını isteyiniz.";
                        break;
                    default:
                        $result["error"] = "Beklenmeyen bir hata oluştu. Lütfen daha sonra tekrar deneyiniz.";
                }
            }
        } else {
            $result["error"] = "Bir bağlantı hatası oluştu. Sunucunuz rwcustema.com adresine bağlanamıyor olabilir. Lütfen sunucunuzdan gerekli ayarları yapmasını isteyiniz. ( Hata Kodu:" . $request["response"]["code"] . " )";
        }
    }
    delete_option($tokenField);
    return (object) $result;
}
function rwcus_theme_update_notification()
{
    echo "\t\t<div class=\"notice notice-info is-dismissible\" style=\"margin-left: 0\">\n\t\t\t<p>";
    echo ucfirst(RWCUS_THEME_SLUG);
    echo " temasında yeni bir güncelleme yapıldı. <a href=\"";
    echo admin_url("/admin.php?page=rwcusupdate");
    echo "\">Buraya</a> tıklayarak güncelleyebilirsiniz. Güncelleme uyarılarını <a href=\"";
    echo admin_url("/admin.php?page=rwcuspanel");
    echo "\">Rwcuspanelden</a> pasif edebilirsiniz.</p>\n\t\t</div>\n\t\t";
}
function rwcusGetUpdateData()
{
    $transientData = get_transient("rwcusUpdateData_" . RWCUS_THEME_SLUG);
    if ($transientData === false) {
        $theme = wp_get_theme();
        $activeVersion = $theme->get("Version");
        if ($activeVersion == "") {
            $array["needupdate"] = false;
            $array["message"] = "style.css dosyasındaki versiyon bilgileriniz geçersiz gibi görünüyor. Güncellemelerin sağlıklı çalışabilmesi için bu dosyayı editlememeniz gerekmektedir.";
        } else {
            $versionFile = wp_remote_get("https://rwcustema.com/api/versions/" . RWCUS_THEME_SLUG . ".php");
            if (is_wp_error($versionFile)) {
                $array["needupdate"] = false;
                $array["message"] = "Uzak siteden güncelleme bilgisi alınamıyor. Lütfen daha sonra tekrar deneyin.";
            } else {
                if ($versionFile["response"]["code"] != 200) {
                    $array["needupdate"] = false;
                    $array["message"] = "Şu anda herhangi bir güncelleme bulunmamaktadır.";
                } else {
                    $array = json_decode($versionFile["body"], true);
                    $array["activeVersion"] = $activeVersion;
                    $versionCompare = version_compare($array["version"], $activeVersion);
                    switch ($versionCompare) {
                        case 1:
                            $array["needupdate"] = true;
                            break;
                        case 0:
                            $array["needupdate"] = false;
                            $array["message"] = "Şu anda son sürümü kullanıyorsunuz. Herhangi bir güncelleme yapmanız gerekmemektedir. Güncellemeler ara ara kontrol edilir ve eğer rwcuspanelden pasif etmediyseniz bu sayfaya gelmenize gerek kalmadan admin panelde size uyarı olarak gösterilir.";
                            break;
                        case -1:
                            $array["needupdate"] = false;
                            $array["message"] = "style.css dosyasındaki versiyon bilgileriniz geçersiz gibi görünüyor. Güncellemelerin sağlıklı çalışabilmesi için bu dosyayı editlememeniz gerekmektedir.";
                            break;
                    }
                }
            }
            set_transient("rwcusUpdateData_" . RWCUS_THEME_SLUG, $array, DAY_IN_SECONDS);
        }
    } else {
        $array = $transientData;
    }
    return $array;
}
function rwcusupdate_page()
{
    if (!current_user_can("administrator")) {
        return NULL;
    }
    echo "\t    <div class=\"rwcusAdminPage\">\n\t        <div class=\"rwcusHeader\">\n\t            <h1>Rwcus Tema Güncelleme</h1>\n\t        </div>\n\t        <div class=\"rwcusInner\">\n\t\t\t\t<div style=\"display: none\">\n\t\t\t\t<textarea class=\"rwcuscode\"></textarea>\n\t\t\t</div>\n\t            ";
    if (!empty($_POST["rwcus_updating"]) && $_GET["page"] == "rwcusupdate") {
        $userField = "rwcus_" . hash("crc32", rwcusgetdomain(home_url())) . "_" . RWCUS_THEME_SLUG . "_key";
        $rwcusField = "rwcus_" . hash("crc32", rwcusgetdomain(home_url())) . "_" . RWCUS_THEME_SLUG . "_rwcus_key";
        $oldLicense = get_option($userField);
        $request = rwcusmakerequest("update");
        if ($request->result) {
            echo "<p><b>Tema başarılı bir şekilde güncellendi!</b></p>";
            delete_transient("rwcusUpdateData_" . RWCUS_THEME_SLUG);
        } else {
            echo "<p><b>HATA: " . $request->error . "</b></p>";
        }
    } else {
        echo "\t                <p>Bu sayfada temanızı tek tıkla son sürüme güncelleyebilirsiniz.</p>\n\t                ";
        $rwcusUpdateData = rwcusgetupdatedata();
        if (!$rwcusUpdateData["needupdate"]) {
            exit($rwcusUpdateData["message"]);
        }
        global $wp_filesystem;
        if (empty($wp_filesystem)) {
            require_once ABSPATH . "wp-admin/includes/file.php";
            WP_Filesystem();
        }
        echo "Güncel tema versiyonunuz <b>" . $rwcusUpdateData["activeVersion"] . "</b> ve temanızı <b>" . $rwcusUpdateData["version"] . "</b> versiyonuna güncelleyebilirsiniz.";
        echo "\t                <p>Son versiyonun çıkış tarihi ";
        echo $rwcusUpdateData["release"];
        echo " ve şu güncellemeler yapıldı:</p>\n\t                <ul>\n\t                    ";
        foreach ($rwcusUpdateData["edits"] as $edit) {
            echo "\t                        <li>";
            echo $edit;
            echo "</li>\n\t                    ";
        }
        echo "\t                </ul>\n\t                <p>";
        echo $rwcusUpdateData["desc"];
        echo "</p>\n\t                ";
        $phpVersionCompare = version_compare(phpversion(), $rwcusUpdateData["minphp"]);
        if ($phpVersionCompare == -1) {
            echo "\t                    <p><b>HATA: Son güncellemeyi yapabilmeniz için PHP versiyonunuzun en az ";
            echo $rwcusUpdateData["minphp"];
            echo " olması gerekmektedir. Halbuki sizin şu anki PHP versiyonunuz: ";
            echo phpversion();
            echo ". Host kontrol panelinizden kendiniz yükseltebilir veya sunucu firmanızdan talep edebilirsiniz.</b></p>\n\t                ";
            exit;
        }
        echo "\n\t                <b>DİKKAT! Tema güncelleme işleminde yeni dosyalar mevcut tema dosyalarınızın üzerine yazılacağı için eğer tema dosyalarında düzenlemeler yaptıysanız bu düzenlemeler kaybolacaktır. Mevcut temanızı yedekleyerek güncelleme sonrasında, düzenlenmiş dosyaları tekrar uygulayabilirsiniz. Kendi düzenlemelerinizin yer aldığı edits klasörü veya eğer kullanıyorsanız child temanızdaki dosyalar bundan etkilenmeyecektir. Tema dosyalarında bir düzenleme yapmadıysanız herhangi bir sorun olmayacaktır.</b></p>\n\t                ";
        $rwcusCheckFileDbPermissions = rwcuscheckfiledbpermissions();
        if (empty($rwcusCheckFileDbPermissions)) {
            echo "\t                    <p><input type=\"checkbox\" name=\"rwcusupdate-accept\" id=\"rwcusupdate-accept\">\n\t                        <label for=\"rwcusupdate-accept\">Yukarıdaki açıklamaları okudum ve tema dosyalarımın güncelleneceğini anladım.</label>\n\t                    </p>\n\t                    <form id=\"rwcusupdate-form\" method=\"post\">\n\t                        <input type=\"hidden\" name=\"rwcus_updating\" value=\"1\" />\n\t                        <input type=\"submit\" name=\"submit\" id=\"rwcusupdate-submit\" disabled class=\"button button-primary\" value=\"Temayı Son Sürüme Güncelle\"  />\n\t                    </form>\n\t                    <div class=\"submitUyari\" style=\"display:none; margin: 20px 0; font-size: 16px;\">Bu işlem, sunucunuzun hızına göre birkaç dakika sürebilmektedir, lütfen sayfayı kapatmayın.</div>\n\t                    <script>\n\t                    jQuery(function(\$) {\n\t                        \$('#rwcusupdate-accept').change(function() {\n\t                            \$('#rwcusupdate-submit').attr('disabled', \$('#rwcusupdate-accept:checked').length == 0);\n\t                        });\n\t                        \$(\"#rwcusupdate-form\").submit(function() {\n\t                            \$('#rwcusupdate-submit, #rwcusupdate-accept').attr('disabled', 'disabled');\n\t                            \$(\".submitUyari\").fadeIn();\n\t                        });\n\t                    });\n\t                    </script>\n\t                    ";
        } else {
            echo "\t                    <h2 class=\"title\">Hata!</h2>\n\t                    <p><b>Bu sistemin çalışabilmesi için sisteminizde bazı özellikler gerekmektedir.</b></p>\n\t                    <ul>\n\t                        ";
            foreach ($rwcusCheckFileDbPermissions as $err) {
                echo "<li>" . $err . "</li>";
            }
            echo "\t                    </ul>\n\t                    ";
        }
        echo "\t            </div>\n\t        </div>\n\t        ";
    }
}
function rwcusdemoimport_page()
{
    if (!current_user_can("administrator")) {
        return NULL;
    }
    echo "\t\t<div class=\"rwcusAdminPage\">\n\t\t\t<div class=\"rwcusHeader\">\n\t\t\t\t<h1>Rwcus Demo İçerik</h1>\n\t\t\t</div>\n\t\t\t<div class=\"rwcusInner\">\n\t\t\t\t";
    if (!empty($_POST["rwcus_importing"]) && $_GET["page"] == "rwcusdemoimport") {
        $userField = "rwcus_" . hash("crc32", rwcusgetdomain(home_url())) . "_" . RWCUS_THEME_SLUG . "_key";
        $rwcusField = "rwcus_" . hash("crc32", rwcusgetdomain(home_url())) . "_" . RWCUS_THEME_SLUG . "_rwcus_key";
        $oldLicense = get_option($userField);
        $request = rwcusmakerequest("demoimport", ["adminuserid" => get_current_user_id()]);
        if ($request->result) {
            flush_rewrite_rules();
            echo "<p><b>Demo içerik başarılı bir şekilde çekildi!</b></p>";
        } else {
            echo "<p><b>HATA: " . $request->error . "</b></p>";
        }
    } else {
        echo "\t\t\t\t\t<p>Bu sayfada tek tuş ile demo içerik aktarımı yapabilirsiniz.<br /><br />\n\t\t\t\t\t<b>DİKKAT! Demo aktarım işlemi tüm yazı, sayfa ve ayarlarınızı siler!<br />\n\t\t\t\t\tBu işlemin sıfır bir wordpress kurulumu ile yapılması tavsiye edilir.</b></p>\n\t\t\t\t\t";
        $rwcusCheckFileDbPermissions = rwcuscheckfiledbpermissions(true);
        if (empty($rwcusCheckFileDbPermissions)) {
            echo "\t\t\t\t\t\t<p><input type=\"checkbox\" name=\"rwcus-demo-import-accept\" id=\"rwcus-demo-import-accept\">\n\t\t\t\t\t\t\t<label for=\"rwcus-demo-import-accept\">Yukarıdaki açıklamaları okudum ve tüm içeriklerimin silineceğini anladım.</label>\n\t\t\t\t\t\t</p>\n\t\t\t\t\t\t<form id=\"rwcus-demo-import-form\" method=\"post\">\n\t\t\t\t\t\t\t<input type=\"hidden\" name=\"rwcus_importing\" value=\"1\" />\n\t\t\t\t\t\t\t<input type=\"submit\" name=\"submit\" id=\"rwcus-demo-import-submit\" disabled class=\"button button-primary\" value=\"Tüm Verileri Sil ve Demo İçerikleri Getir!\"  />\n\t\t\t\t\t\t</form>\n\t\t\t\t\t\t<div class=\"submitUyari\" style=\"display:none; margin: 20px 0; font-size: 16px;\">Bu işlem, sunucunuzun hızına göre birkaç dakika sürebilmektedir, lütfen sayfayı kapatmayın.</div>\n\t\t\t\t\t\t<script>\n\t\t\t\t\t\tjQuery(function(\$) {\n\t\t\t\t\t\t\t\$('#rwcus-demo-import-accept').change(function() {\n\t\t\t\t\t\t\t\t\$('#rwcus-demo-import-submit').attr('disabled', \$('#rwcus-demo-import-accept:checked').length == 0);\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\t\$(\"#rwcus-demo-import-form\").submit(function() {\n\t\t\t\t\t\t\t\t\$('#rwcus-demo-import-submit, #rwcus-demo-import-accept').attr('disabled', 'disabled');\n\t\t\t\t\t\t\t\t\$(\".submitUyari\").fadeIn();\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t});\n\t\t\t\t\t\t</script>\n\t\t\t\t\t\t";
        } else {
            echo "\t\t\t\t\t\t<h2 class=\"title\">Hata!</h2>\n\t\t\t\t\t\t<p><b>Bu sistemin çalışabilmesi için sisteminizde bazı özellikler gerekmektedir.</b></p>\n\t\t\t\t\t\t<ul>\n\t\t\t\t\t\t\t";
            foreach ($rwcusCheckFileDbPermissions as $err) {
                echo "<li>" . $err . "</li>";
            }
            echo "\t\t\t\t\t\t</ul>\n\t\t\t\t\t\t";
        }
        echo "\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t";
    }
}

?>