<?php if(!defined('ABSPATH')) exit; ?>
<?php get_header(); ?>
<?php the_post(); ?>

<div id="main" class="innerContainer">
	<div id="content">
		<div id="single" class="attachmentPage">
			<div class="rwcusBox">
				<?php
				global $post;
				$attachmentIDs = "";
				$attachmentIDs = rwcus_get_gallery_ids($post->post_parent);

				if(is_array($attachmentIDs)) {
					$totalAttachmentNumber = count($attachmentIDs);
					$currentAttachmentNumber = array_search($post->ID, $attachmentIDs) + 1;

					if ($currentAttachmentNumber == $totalAttachmentNumber) {
						$prevAttachmentURL = get_attachment_link($attachmentIDs[$totalAttachmentNumber - 2]);
					} elseif($currentAttachmentNumber == 1) {
						$nextAttachmentURL = get_attachment_link($attachmentIDs[1]);
					} else {
						$nextAttachmentURL = get_attachment_link($attachmentIDs[$currentAttachmentNumber]);
						$prevAttachmentURL = get_attachment_link($attachmentIDs[$currentAttachmentNumber - 2]);
					}
					?>
					<?php
				}
				?>
				<?php if(xoption("metaboxPosition") == "top") get_template_part('lib/rwcustema/metabox'); ?>

				<div id="galleryContent">
					<div class="imageBlock">
						<?php
						if(is_array($attachmentIDs)) {
							echo wp_get_attachment_image( $post->ID, 'full');
							?>
								<?php if($currentAttachmentNumber != 1) : ?>
									<a class="navButton prev" href="<?php echo $prevAttachmentURL; ?>#main"><?php themeIcon("left") ?></a>
								<?php endif; ?>
								<?php if($currentAttachmentNumber != $totalAttachmentNumber) : ?>
									<a class="navButton next" href="<?php echo $nextAttachmentURL; ?>#main"><?php themeIcon("right") ?></a>
								<?php endif; ?>
							<?php
						} else {
							echo wp_get_attachment_image( $post->ID, 'full');
						}
						?>
					</div>
					<div class="reading">
						<?php the_content();?>
					</div>
				</div>

				<?php
				if(is_array($attachmentIDs)) { ?>
					<div class="gallery-nav">
						<?php
						$buttonCount = 8;
						if($totalAttachmentNumber<=$buttonCount) {
							$counter = 0;
							foreach ($attachmentIDs as $ID) : $counter++; ?>
								<a href="<?php echo get_attachment_link($ID);?>#main" class="<?php if($currentAttachmentNumber == $counter) echo 'active'?>"><?php echo $counter; ?></a><?php
							endforeach;
						} else {
							if($currentAttachmentNumber != 1) {
								?><a href="<?php echo get_attachment_link($attachmentIDs[0]);?>#main">&laquo;</a><?php
								?><a class="left" href="<?php echo get_attachment_link($attachmentIDs[$currentAttachmentNumber-2]);?>#main">&lt;</a><?php
							}

							/*Middle*/
							if($totalAttachmentNumber == $buttonCount) {
								$galleryNumbers = range(1,$buttonCount);
							} else {
								if($currentAttachmentNumber<=($buttonCount/2)) {
									$galleryNumbers = range(1,$buttonCount);
								} elseif( ($totalAttachmentNumber - $currentAttachmentNumber) <= ($buttonCount/2-1)) {
									$galleryNumbers = range($totalAttachmentNumber - $buttonCount + 1, $totalAttachmentNumber);
								} else {
									$galleryNumbers = range($currentAttachmentNumber-3, $currentAttachmentNumber+4);
								}
							}
							foreach ($galleryNumbers as $galleryNumber) {
								?><a <?php if($currentAttachmentNumber == $galleryNumber) echo 'class="active"'; ?> href="<?php echo get_attachment_link($attachmentIDs[$galleryNumber-1]);?>#main"><?php echo $galleryNumber ?></a><?php
							}
							/*Middle*/

							if($currentAttachmentNumber != $totalAttachmentNumber) {
								?><a class="right" href="<?php echo get_attachment_link($attachmentIDs[$currentAttachmentNumber]);?>#main">&gt;</a><a href="<?php echo get_attachment_link($attachmentIDs[$totalAttachmentNumber-1]);?>#main">&raquo;</a><?php
							}
						}
						?>
					</div>
					<div style="text-align:center;color:#999;line-height:25px;">
						<?php if(!wp_is_mobile()) : ?>
							<p><?php _e("Klavye yön tuşlarını kullanarak resimler arasında geçiş yapabilirsiniz","rcza") ?>.</p>
						<?php endif; ?>
						<p><?php _e("Konuya Geri Dön","rcza") ?>: <a href="<?php echo get_permalink($post->post_parent); ?>"><b><?php echo get_the_title($post->post_parent); ?></b></a></p>
					</div>
					<?php
				}
				?>

				<?php if(xoption("metaboxPosition") == "bottom") get_template_part('lib/rwcustema/metabox'); ?>
			</div>

			<?php if(xoption("singleCommentsActive") && comments_open()) comments_template(); ?>

		</div>
	</div>	
	<?php rwcus_sidebar(); ?>
</div>
<?php get_footer(); ?>
<style>

	.imageBlock {
		margin-bottom: 15px;
		position: relative;
	}

	.imageBlock img {
		display: block;
		margin: auto;
	}

	.navButton {
		position: absolute;
		width: 50%;
		height: 100%;
		display: block;
		top: 0;
		transition: all .3s;
		opacity: 0.7;
	}

	.navButton:hover {
		opacity: 1;
	}

	.navButton .icon {
		position: absolute;
		width: 60px;
		height: 60px;
		top: 50%;
		transform: translateY(-50%);
		color: #fff;
		background: rgba(0,0,0,0.2);
		display: flex;
		align-items: center;
	}

	.navButton .icon svg {
		width: 30px;
		height: 30px;
	}

	.navButton.prev {
		left: 0;
	}

	.navButton.next {
		right: 0;
	}

	.navButton.prev .icon {
		left: 10px;
	}

	.navButton.next .icon {
		right: 10px;
	}

	.reading p {
		text-align: center;
	}

	.gallery-nav {
		display: flex;
		flex-wrap: wrap;
		justify-content: center;
		gap: 5px;
		margin: 15px 0;
	}	

	.gallery-nav a {
		color: #fff;
		background: var(--c1);
		padding: 8px 12px;
		font-weight: 600;
		border-radius: 3px;
		transition:all .2s;
	}

	.gallery-nav a:hover, .gallery-nav a.active {
		background: var(--c2);
	}

	@media all and (max-width:768px) {

		.navButton .icon {
			width: 30px;
			height: 30px;
		}

		.navButton .icon svg {
			width: 16px;
			height: 16px;
		}


	}

</style>
