<?php
/*
Plugin Name: Renatif - 301 Yönlendirme
Plugin URI: https://www.renatif.com.tr
Description: Başka bir sayfaya veya siteye 301 yönlendirme yapabilme özelliğini kazandıran eklentidir.
Version: 1.07
Author: Renatif Web Çözümleri
Author URI: https://www.renatif.com.tr
*/

if (!class_exists("Renatif301redirects")) {
	class Renatif301Redirects {
		function create_menu() {
		  add_options_page('301 Yönlendirme', '301 Yönlendirme', 'manage_options', '301options', array($this,'options_page'));
		}
		function options_page() {
		?>
		<div class="wrap renatif_301_redirects">
			<script>
				jQuery(document).ready(function(){
					jQuery('span.wps301-delete').html('Kaldır').css({'color':'red','cursor':'pointer'}).click(function(){
						var confirm_delete = confirm('Bu yönlendirmeyi kaldırmak istediğinizden emin misiniz?');
						if (confirm_delete) {
							jQuery(this).parent().parent().remove();
							jQuery('#renatif_301_redirects_form').submit();
						}
					});
					jQuery('.renatif_301_redirects .documentation').hide().before('<p><a class="reveal-documentation" href="#">Documentation</a></p>')
					jQuery('.reveal-documentation').click(function(){
						jQuery(this).parent().siblings('.documentation').slideToggle();
						return false;
					});
				});
			</script>
		<?php
			if (isset($_POST['301_redirects'])) {
				echo '<div id="message" class="updated"><p>Ayarlar kaydedildi.</p></div>';
			}
		?>
			<h2>Renatif - 301 Yönlendirme</h2>
			<form method="post" id="renatif_301_redirects_form" action="options-general.php?page=301options&savedata=true">
			<?php wp_nonce_field( 'save_redirects', '_s301r_nonce' ); ?>
			<table class="widefat">
				<thead>
					<tr>
						<th colspan="2">İstek</th>
						<th colspan="2">Hedef</th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td colspan="2"><small>örnek: /hakkimizda.html</small></td>
						<td colspan="2"><small>örnek: <?php echo get_option('home'); ?>/hakkimizda/</small></td>
					</tr>
					<?php echo $this->expand_redirects(); ?>
					<tr>
						<td style="width:35%;"><input type="text" name="301_redirects[request][]" value="" style="width:99%;" /></td>
						<td style="width:2%;">&raquo;</td>
						<td style="width:60%;"><input type="text" name="301_redirects[destination][]" value="" style="width:99%;" /></td>
						<td><span class="wps301-delete">Kaldır</span></td>
					</tr>
				</tbody>
			</table>
			<?php $wildcard_checked = (get_option('301_redirects_wildcard') === 'true' ? ' checked="checked"' : ''); ?>
			<p><input type="checkbox" name="301_redirects[wildcard]" id="wps301-wildcard"<?php echo $wildcard_checked; ?> /><label for="wps301-wildcard"> Wildcard Kullan</label></p>
			<p class="submit"><input type="submit" name="submit_301" class="button-primary" value="<?php _e('Save Changes') ?>" /></p>
			</form>
		</div>
		<?php
		} // options_page	
		function expand_redirects() {
			$redirects = get_option('301_redirects');
			$output = '';
			if (!empty($redirects)) {
				foreach ($redirects as $request => $destination) {
					$output .= '
					
					<tr>
						<td><input type="text" name="301_redirects[request][]" value="'.$request.'" style="width:99%" /></td>
						<td>&raquo;</td>
						<td><input type="text" name="301_redirects[destination][]" value="'.$destination.'" style="width:99%;" /></td>
						<td><span class="wps301-delete"></span></td>
					</tr>
					';
				}
			} // end if
			return $output;
		}
		function save_redirects($data) {
			if ( !current_user_can('manage_options') )  { wp_die( 'You do not have sufficient permissions to access this page.' ); }
			check_admin_referer( 'save_redirects', '_s301r_nonce' );
			$data = $_POST['301_redirects'];
			$redirects = array();
			for($i = 0; $i < sizeof($data['request']); ++$i) {
				$request = trim( sanitize_text_field( $data['request'][$i] ) );
				$destination = trim( sanitize_text_field( $data['destination'][$i] ) );
				if ($request == '' && $destination == '') { continue; }
				else { $redirects[$request] = $destination; }
			}
			update_option('301_redirects', $redirects);
			if (isset($data['wildcard'])) {
				update_option('301_redirects_wildcard', 'true');
			}
			else {
				delete_option('301_redirects_wildcard');
			}
		}
		function redirect() {
			$userrequest = str_ireplace(get_option('home'),'',$this->get_address());
			$userrequest = rtrim($userrequest,'/');
			$redirects = get_option('301_redirects');
			if (!empty($redirects)) {
				$wildcard = get_option('301_redirects_wildcard');
				$do_redirect = '';
				foreach ($redirects as $storedrequest => $destination) {
					if ($wildcard === 'true' && strpos($storedrequest,'*') !== false) {
						if ( strpos($userrequest, '/wp-login') !== 0 && strpos($userrequest, '/wp-admin') !== 0 ) {
							$storedrequest = str_replace('*','(.*)',$storedrequest);
							$pattern = '/^' . str_replace( '/', '\/', rtrim( $storedrequest, '/' ) ) . '/';
							$destination = str_replace('*','$1',$destination);
							$output = preg_replace($pattern, $destination, $userrequest);
							if ($output !== $userrequest) {
								$do_redirect = $output;
							}
						}
					}
					elseif(urldecode($userrequest) == rtrim($storedrequest,'/')) {
						$do_redirect = $destination;
					}
					if ($do_redirect !== '' && trim($do_redirect,'/') !== trim($userrequest,'/')) {
						if (strpos($do_redirect,'/') === 0){
							$do_redirect = home_url().$do_redirect;
						}
						header ('HTTP/1.1 301 Moved Permanently');
						header ('Location: ' . $do_redirect);
						exit();
					}
					else { unset($redirects); }
				}
			}
		} // sonksiyon sonu redirect
		function get_address() {
			return $this->get_protocol().'://'.$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
		}
		function get_protocol() {
			$protocol = 'http';
			if ( isset( $_SERVER["HTTPS"] ) && strtolower( $_SERVER["HTTPS"] ) == "on" ) {
    			$protocol .= "s";
			}
			return $protocol;
		}
	}
}
$redirect_plugin = new Renatif301Redirects();
if (isset($redirect_plugin)) {
	add_action('init', array($redirect_plugin,'redirect'), 1);
	add_action('admin_menu', array($redirect_plugin,'create_menu'));
	if (isset($_POST['301_redirects'])) {
		add_action('admin_init', array($redirect_plugin,'save_redirects'));
	}
}
if(!function_exists('str_ireplace')){
  function str_ireplace($search,$replace,$subject){
    $token = chr(1);
    $haystack = strtolower($subject);
    $needle = strtolower($search);
    while (($pos=strpos($haystack,$needle))!==FALSE){
      $subject = substr_replace($subject,$token,$pos,strlen($search));
      $haystack = substr_replace($haystack,$token,$pos,strlen($search));
    }
    $subject = str_replace($token,$replace,$subject);
    return $subject;
  }
}